<?php

namespace App\Filament\Blocks;

use Filament\Forms\Components\Builder\Block;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;

class HtmlBlock
{
    public static function make(): Block
    {
        return Block::make('html')
            ->label('قسم HTML (كود حر)')
            ->icon('heroicon-o-code-bracket')
            ->schema([
                TextInput::make('title')
                    ->label('عنوان داخلي (للمرجع فقط)')
                    ->placeholder('For admin reference only')
                    ->live(debounce: 700)
                    ->maxLength(255),
                
                        Textarea::make('html_content')
                            ->label('محتوى HTML')
                            ->placeholder('الصق كود HTML هنا...')
                            ->rows(14)
                            ->live(debounce: 700),
                
                Toggle::make('full_width')
                    ->label('عرض كامل')
                    ->default(false)
                    ->helperText('عرض المحتوى بعرض الصفحة بالكامل.'),
                
                Toggle::make('add_container')
                    ->label('إضافة حاوية وبادينغ')
                    ->default(true)
                    ->helperText('إضافة حاوية قياسية حول المحتوى.'),
            ]);
    }
}
