<?php

namespace App\Filament\Blocks;

use Filament\Forms\Components\Builder\Block;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\Select;
class PackageGridBlock
{
    public static function make(): Block
    {
        return Block::make('package_grid')
            ->label('عرض الباقات')
            ->icon('heroicon-o-squares-2x2')
            ->schema([
                        TextInput::make('title')->label('عنوان القسم')->maxLength(255)->live(debounce: 700)->placeholder('مثال: باقاتنا'),
                        Textarea::make('description')->label('وصف')->rows(2)->live(debounce: 700)->maxLength(500),
                        TextInput::make('view_all_text')
                            ->label('نص زر عرض الكل')
                            ->default('عرض جميع الباقات')
                            ->live(debounce: 700),
                            TextInput::make('view_all_url')
                            ->label('رابط زر عرض الكل')
                            ->default('/packages')
                            ->live(debounce: 700),
                
                Select::make('packages_source')
                    ->label('مصدر الباقات')
                    ->options([
                        'latest' => 'الأحدث',
                        'featured' => 'المميزة',
                        'selected' => 'المحددة',
                        'all' => 'الكل',
                    ])
                    ->default('featured')
                    ->required(),
                
                TextInput::make('limit')
                    ->label('عدد الباقات')
                    ->default(6)
                    ->numeric()
                    ->minValue(1)
                    ->maxValue(12),
                
                Select::make('columns')
                    ->label('عدد الأعمدة')
                    ->options([
                        '2' => '٢',
                        '3' => '٣',
                        '4' => '٤',
                    ])
                    ->default('3')
                    ->required(),
                
                Toggle::make('show_view_all')
                    ->label('إظهار زر «عرض الكل»')
                    ->default(true),
            ]);
    }
}
