<?php

namespace App\Filament\Blocks;

use Filament\Forms\Components\Builder\Block;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Repeater;

class PrismaAboutBlock
{
    public static function make(): Block
    {
        return Block::make('prisma_about')
            ->label('من نحن (Prisma)')
            ->icon('heroicon-o-information-circle')
            ->schema([
                        TextInput::make('title')
                            ->label('العنوان الرئيسي')
                            ->default('مختبرات بريزما الطبية – شريكك الصحي الموثوق')
                            ->live(debounce: 700),
                        
                        Textarea::make('description')
                            ->label('الوصف')
                            ->default('مختبرات بريزما الطبية هي مختبر تحاليل معتمد يقدّم خدمات مخبرية متكاملة باستخدام أحدث الأجهزة الطبية، وبإشراف نخبة من المختصين، مع الالتزام بأعلى معايير الجودة والدقة.')
                            ->rows(4)
                            ->live(debounce: 700),
                        
                        TextInput::make('button_text')
                            ->label('نص الزر الأساسي')
                            ->default('اكتشف الباقات')
                            ->live(debounce: 700),

                Section::make('Links & Actions')
                    ->schema([
                        TextInput::make('button_url')
                            ->label('Primary Button URL')
                            ->default('/packages')
                            ->live(debounce: 700),
                        
                        Toggle::make('show_call_button')
                            ->label('Show Call Button')
                            ->default(true),
                    ]),
                
                Section::make('Image')
                    ->schema([
                        FileUpload::make('image')
                            ->label('About Image')
                            ->image()
                            ->directory('about'),
                        
                        Toggle::make('show_default_icon')
                            ->label('Show Default Icon if No Image')
                            ->default(true)
                            ->helperText('Shows a microscope icon when no image uploaded'),
                    ]),
                
                Section::make('Stats (optional)')
                    ->schema([
                        Toggle::make('show_stats')
                            ->label('Show Stats Badge')
                            ->default(true),
                        
                        Repeater::make('stats')
                            ->label('Stats')
                            ->schema([
                                TextInput::make('value')
                                    ->label('Value')
                                    ->required(),
                                
                                TextInput::make('label')
                                    ->label('Label')
                                    ->required(),
                            ])
                            ->default([
                                ['value' => '24', 'label' => 'ساعة نتائج'],
                                ['value' => '100%', 'label' => 'معتمد'],
                                ['value' => 'مجاناً', 'label' => 'السحب المنزلي'],
                            ])
                            ->columns(2)
                            ->maxItems(4)
                            ->visible(fn ($get) => $get('show_stats')),
                    ]),
                
                Section::make('Layout')
                    ->schema([
                        Toggle::make('image_on_right')
                            ->label('Image on Right Side')
                            ->default(false),
                        
                        Toggle::make('full_width')
                            ->label('Full Width Background')
                            ->default(true),
                    ])
                    ->collapsed(),
            ]);
    }
}
