<?php

namespace App\Filament\Blocks;

use Filament\Forms\Components\Builder\Block;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Components\ColorPicker;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Section;

class PrismaCtaBlock
{
    public static function make(): Block
    {
        return Block::make('prisma_cta')
            ->label('دعوة لاتصال (Prisma)')
            ->icon('heroicon-o-megaphone')
            ->schema([
                        TextInput::make('title')
                            ->label('العنوان الرئيسي')
                            ->default('جاهز للحجز؟')
                            ->live(debounce: 700),
                        
                        Textarea::make('subtitle')
                            ->label('العنوان الفرعي')
                            ->default('احجز الآن واحصل على خصم 10% على أول تحليل لك')
                            ->rows(2)
                            ->live(debounce: 700),
                        
                        TextInput::make('button_text')
                            ->label('نص الزر')
                            ->default('احجز عبر الواتساب')
                            ->live(debounce: 700),

                Section::make('Links & Icon')
                    ->schema([
                        TextInput::make('button_url')
                            ->label('Button URL')
                            ->default('#')
                            ->live(debounce: 700)
                            ->helperText('Use WhatsApp link or any URL'),
                        
                        Select::make('button_icon')
                            ->label('Button Icon')
                            ->options([
                                'whatsapp' => 'WhatsApp',
                                'phone' => 'Phone',
                                'arrow' => 'Arrow',
                                'calendar' => 'Calendar',
                            ])
                            ->default('whatsapp'),
                    ]),
                
                Section::make('Design')
                    ->schema([
                        ColorPicker::make('bg_color_start')
                            ->label('Gradient Start')
                            ->default('#00A0B0'),
                        
                        ColorPicker::make('bg_color_end')
                            ->label('Gradient End')
                            ->default('#2D9CDB'),
                        
                        Toggle::make('rounded_corners')
                            ->label('Rounded Corners')
                            ->default(true),
                        
                        Toggle::make('full_width')
                            ->label('Full Width')
                            ->default(false),
                        
                        Toggle::make('margin_top')
                            ->label('Add Top Margin')
                            ->default(true),
                    ])
                    ->columns(3),
            ]);
    }
}
