<?php

namespace App\Filament\Blocks;

use Filament\Forms\Components\Builder\Block;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\ColorPicker;
use Filament\Forms\Components\TextInput;

class PrismaSeparatorBlock
{
    public static function make(): Block
    {
        return Block::make('prisma_separator')
            ->label('فاصل / مساحة (Separator)')
            ->icon('heroicon-o-minus')
            ->schema([
                \Filament\Forms\Components\Placeholder::make('preview')
                    ->label('')
                    ->content(new \Illuminate\Support\HtmlString('<div style="border-top: 2px solid #e2e8f0; margin: 10px 0;"></div>'))
                    ->visible(fn ($get) => $get('type') === 'divider')
                    ->columnSpanFull(),
                
                \Filament\Forms\Components\Placeholder::make('preview_spacer')
                    ->label('')
                    ->content(new \Illuminate\Support\HtmlString('<div style="height: 20px; border: 1px dashed #cbd5e1; border-radius: 4px; display: flex; align-items: center; justify-content: center; color: #64748B; font-size: 12px;">مساحة فارغة (Spacing)</div>'))
                    ->visible(fn ($get) => $get('type') === 'spacer')
                    ->columnSpanFull(),

                Select::make('type')
                    ->label('نوع الفاصل')
                    ->options([
                        'spacer' => 'مساحة فارغة (Spacer)',
                        'divider' => 'خط أفقي (Divider)',
                    ])
                    ->default('spacer')
                    ->live(),
                
                Select::make('height')
                    ->label('الارتفاع / المسافة')
                    ->options([
                        'xs' => 'صغير جداً (20px)',
                        'sm' => 'صغير (40px)',
                        'md' => 'متوسط (60px)',
                        'lg' => 'كبير (80px)',
                        'xl' => 'كبير جداً (120px)',
                    ])
                    ->default('md'),
                
                ColorPicker::make('color')
                    ->label('لون الخط')
                    ->default('#e2e8f0')
                    ->visible(fn ($get) => $get('type') === 'divider'),
                
                TextInput::make('width')
                    ->label('عرض الخط (%)')
                    ->numeric()
                    ->default(100)
                    ->suffix('%')
                    ->visible(fn ($get) => $get('type') === 'divider'),
            ])
            ->columns(2);
    }
}
