<?php

namespace App\Filament\Resources;

use App\Filament\Resources\CustomFormResource\Pages;
use App\Filament\Resources\CustomFormResource\RelationManagers;
use App\Models\CustomForm;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class CustomFormResource extends Resource
{
    protected static ?string $model = CustomForm::class;

    protected static ?string $navigationIcon = 'heroicon-o-document-text';
    protected static ?string $navigationLabel = 'النماذج المخصصة';
    protected static ?string $modelLabel = 'نموذج';
    protected static ?string $pluralModelLabel = 'النماذج المخصصة';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Group::make()
                    ->schema([
                        Forms\Components\Section::make('معلومات النموذج')
                            ->schema([
                                Forms\Components\TextInput::make('name')
                                    ->label('اسم النموذج (عربي)')
                                    ->required()
                                    ->maxLength(255),
                                Forms\Components\TextInput::make('name_translations.en')
                                    ->label('Model Name (English)')
                                    ->maxLength(255),
                                Forms\Components\Toggle::make('is_active')
                                    ->label('نشط')
                                    ->default(true),
                            ])->columns(2),

                        Forms\Components\Section::make('حقول النموذج')
                            ->description('أضف الحقول التي تريدها في النموذج الخاص بك.')
                            ->schema([
                                Forms\Components\Repeater::make('fields')
                                    ->label('الحقول')
                                    ->schema([
                                        Forms\Components\TextInput::make('name')
                                            ->label('اسم الحقل (عربي)')
                                            ->required(),
                                        Forms\Components\TextInput::make('name_translations.en')
                                            ->label('Field Name (English)'),
                                        Forms\Components\TextInput::make('key')
                                            ->label('المفتاح البرمجي (للتخزين، إنجليزي بدون مسافات)')
                                            ->required()
                                            ->alphaDash(),
                                        Forms\Components\Select::make('type')
                                            ->label('نوع الحقل')
                                            ->options([
                                                'text' => 'نص قصير',
                                                'email' => 'بريد إلكتروني',
                                                'tel' => 'رقم جوال',
                                                'textarea' => 'نص طويل (ملاحظات)',
                                                'select' => 'قائمة منسدلة',
                                            ])
                                            ->required()
                                            ->live(),
                                        Forms\Components\TextInput::make('options')
                                            ->label('خيارات القائمة المنسدلة (Arabic, English, ...)')
                                            ->visible(fn (Forms\Get $get) => $get('type') === 'select'),
                                        Forms\Components\Toggle::make('is_required')
                                            ->label('مطلوب (إجباري)')
                                            ->default(true),
                                    ])
                                    ->columns(2)
                                    ->collapsible()
                                    ->itemLabel(fn (array $state): ?string => $state['name'] ?? null)
                                    ->reorderableWithButtons(),
                            ]),
                            
                        Forms\Components\Section::make('إعدادات الواجهة بعد الإرسال')
                            ->schema([
                                Forms\Components\TextInput::make('submit_button_text')
                                    ->label('نص زر الإرسال (عربي)')
                                    ->default('إرسال الدعم'),
                                Forms\Components\TextInput::make('submit_button_text_translations.en')
                                    ->label('Submit Button Text (English)')
                                    ->default('Submit'),
                                Forms\Components\Textarea::make('success_message')
                                    ->label('رسالة النجاح (عربي)')
                                    ->default('تم إرسال طلبك بنجاح. سنتواصل معك قريباً.')
                                    ->rows(3),
                                Forms\Components\Textarea::make('success_message_translations.en')
                                    ->label('Success Message (English)')
                                    ->default('Your request has been sent successfully. We will contact you soon.')
                                    ->rows(3),
                            ])->columns(2),
                    ])
                    ->columnSpan(['lg' => 2]),

                Forms\Components\Group::make()
                    ->schema([
                        Forms\Components\Section::make('تنبيهات البريد الإلكتروني')
                            ->schema([
                                Forms\Components\Toggle::make('send_email')
                                    ->label('تفعيل التنبيه بالبريد')
                                    ->live(),
                                Forms\Components\TextInput::make('email_to')
                                    ->label('البريد المرسل إليه')
                                    ->email()
                                    ->visible(fn (Forms\Get $get) => $get('send_email')),
                                Forms\Components\TextInput::make('email_subject')
                                    ->label('عنوان الإيميل')
                                    ->visible(fn (Forms\Get $get) => $get('send_email')),
                            ]),

                        Forms\Components\Section::make('توجيه واتساب (WhatsApp Redirect)')
                            ->description('توجيه المستخدم لتطبيق واتساب مع إرسال تفاصيل النموذج كرسالة.')
                            ->schema([
                                Forms\Components\Toggle::make('send_whatsapp')
                                    ->label('تفعيل توجيه واتساب')
                                    ->live(),
                                Forms\Components\TextInput::make('whatsapp_number')
                                    ->label('رقم الواتساب (مع رمز الدولة)')
                                    ->numeric()
                                    ->placeholder('966500000000')
                                    ->visible(fn (Forms\Get $get) => $get('send_whatsapp')),
                                Forms\Components\Textarea::make('whatsapp_message_template')
                                    ->label('قالب الرسالة')
                                    ->helperText('يمكنك استخدام مفاتيح الحقول مثل: {name}, {phone}, إلخ.')
                                    ->visible(fn (Forms\Get $get) => $get('send_whatsapp'))
                                    ->rows(4),
                            ]),

                        Forms\Components\Section::make('ربط خارجي (Webhooks / Google Sheets)')
                            ->description('إرسال البيانات إلى Zapier أو Make.com أو Google Apps Script.')
                            ->schema([
                                Forms\Components\Toggle::make('send_webhook')
                                    ->label('تفعيل الـ Webhook')
                                    ->live(),
                                Forms\Components\TextInput::make('webhook_url')
                                    ->label('رابط الـ Webhook (URL)')
                                    ->url()
                                    ->visible(fn (Forms\Get $get) => $get('send_webhook')),
                            ]),
                    ])
                    ->columnSpan(['lg' => 1]),
            ])
            ->columns(3);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label('اسم النموذج')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('submissions_count')
                    ->label('الردود')
                    ->counts('submissions')
                    ->badge(),
                Tables\Columns\IconColumn::make('send_email')
                    ->label('إيميل')
                    ->boolean(),
                Tables\Columns\IconColumn::make('send_whatsapp')
                    ->label('واتساب')
                    ->boolean(),
                Tables\Columns\IconColumn::make('send_webhook')
                    ->label('ربط خارجي')
                    ->boolean(),
                Tables\Columns\ToggleColumn::make('is_active')
                    ->label('نشط'),
                Tables\Columns\TextColumn::make('created_at')
                    ->label('تاريخ الإنشاء')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListCustomForms::route('/'),
            'create' => Pages\CreateCustomForm::route('/create'),
            'edit' => Pages\EditCustomForm::route('/{record}/edit'),
        ];
    }
}
