<?php

namespace App\Filament\Resources\TestCategoryResource\Pages;

use App\Filament\Resources\TestCategoryResource;
use App\Models\Test;
use Filament\Resources\Pages\CreateRecord;

class CreateTestCategory extends CreateRecord
{
    protected static string $resource = TestCategoryResource::class;

    protected function afterCreate(): void
    {
        $data = $this->form->getState();
        $testIds = $data['test_ids'] ?? [];
        if (!empty($testIds)) {
            Test::whereIn('id', $testIds)->update(['test_category_id' => $this->record->id]);
        }
    }
}
