<?php

namespace App\Filament\Widgets;

use App\Models\CustomFormSubmission;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;

class RecentSubmissionsWidget extends BaseWidget
{
    protected static ?int $sort = 3;
    protected int | string | array $columnSpan = 'full';

    public function table(Table $table): Table
    {
        return $table
            ->query(
                CustomFormSubmission::query()->latest()->limit(5)
            )
            ->heading('أحدث النماذج المستلمة')
            ->columns([
                Tables\Columns\TextColumn::make('form.name')
                    ->label('النموذج')
                    ->badge()
                    ->color('primary'),
                Tables\Columns\TextColumn::make('created_at')
                    ->label('تاريخ الاستلام')
                    ->dateTime('d M Y - H:i')
                    ->sortable(),
                Tables\Columns\TextColumn::make('ip_address')
                    ->label('IP Address')
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->actions([
                Tables\Actions\Action::make('view')
                    ->label('عرض التفاصيل')
                    ->icon('heroicon-o-eye')
                    ->url(fn (CustomFormSubmission $record): string => route('filament.admin.resources.custom-form-submissions.index'))
            ])
            ->paginated(false);
    }
}
