<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Package;
use App\Models\Page;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        // Get homepage page or create default
        $page = Page::where('is_homepage', true)->where('is_published', true)->first();
        
        // If no homepage page exists, create default content with Prisma blocks
        if (!$page) {
            $page = $this->getDefaultHomepagePage();
        }
        
        return view('pages.show', compact('page'));
    }
    
    private function getDefaultHomepagePage(): Page
    {
        return new Page([
            'title' => 'مختبرات بريزما الطبية',
            'meta_title' => $this->getSiteSetting('meta_title', 'مختبرات بريزما الطبية - فحوصات معتمدة ونتائج دقيقة'),
            'meta_description' => $this->getSiteSetting('meta_description', 'مختبرات بريزما الطبية تقدم فحوصات معتمدة ونتائج دقيقة'),
            'meta_keywords' => $this->getSiteSetting('meta_keywords', 'مختبر, تحاليل, فحوصات طبية'),
            'content' => [
                [
                    'type' => 'prisma_hero',
                    'data' => [
                        'title' => $this->getSiteSetting('hero_title', 'صحتك تبدأ بفحص دقيق'),
                        'subtitle' => $this->getSiteSetting('hero_subtitle', 'نتائج موثوقة خلال 24 ساعة مع خدمة السحب المنزلي المجانية'),
                        'cta_text' => $this->getSiteSetting('hero_cta_text', 'احجز الآن'),
                        'cta_url' => $this->getSiteSetting('hero_cta_url', '#packages'),
                        'full_width' => true,
                        'show_pattern' => true,
                    ],
                ],
                [
                    'type' => 'prisma_categories',
                    'data' => [
                        'show_from_database' => true,
                        'limit' => 8,
                        'show_names' => true,
                        'card_style' => true,
                    ],
                ],
                [
                    'type' => 'prisma_packages',
                    'data' => [
                        'badge_text' => $this->getSiteSetting('promo_badge_text', 'عروض الموسم المميزة'),
                        'title' => $this->getSiteSetting('promo_title', 'باقات مختبرات بريزما'),
                        'subtitle' => $this->getSiteSetting('promo_subtitle', 'استفد من عرض: اختر باقتين واحصل على الثالثة مجاناً!'),
                        'show_tier_99' => $this->getSiteSetting('show_packages_99', true),
                        'show_tier_199' => $this->getSiteSetting('show_packages_199', true),
                        'show_tier_299' => $this->getSiteSetting('show_packages_299', true),
                        'show_description' => true,
                        'show_features' => true,
                        'show_badge' => true,
                        'show_tests_count' => true,
                        'show_old_price' => true,
                        'card_hover_effect' => true,
                    ],
                ],
                [
                    'type' => 'prisma_about',
                    'data' => [
                        'title' => $this->getSiteSetting('about_title', 'مختبرات بريزما الطبية – شريكك الصحي الموثوق'),
                        'description' => $this->getSiteSetting('about_description', 'مختبرات بريزما الطبية هي مختبر تحاليل معتمد يقدّم خدمات مخبرية متكاملة...'),
                        'button_text' => 'اكتشف الباقات',
                        'button_url' => '/packages',
                        'show_call_button' => true,
                        'show_default_icon' => true,
                        'show_stats' => true,
                        'stats' => [
                            ['value' => $this->getSiteSetting('stat_1_value', '24'), 'label' => $this->getSiteSetting('stat_1_label', 'ساعة نتائج')],
                            ['value' => $this->getSiteSetting('stat_2_value', '100%'), 'label' => $this->getSiteSetting('stat_2_label', 'معتمد')],
                            ['value' => $this->getSiteSetting('stat_3_value', 'مجاناً'), 'label' => $this->getSiteSetting('stat_3_label', 'السحب المنزلي')],
                        ],
                        'image_on_right' => false,
                        'full_width' => true,
                    ],
                ],
                [
                    'type' => 'prisma_services',
                    'data' => [
                        'title' => 'خدماتنا المميزة',
                        'subtitle' => 'نقدم لك مجموعة متكاملة من الخدمات المخبرية بأعلى معايير الجودة',
                        'show_icon_background' => true,
                        'card_border' => true,
                        'center_align' => true,
                    ],
                ],
                [
                    'type' => 'prisma_faq',
                    'data' => [
                        'title' => 'الأسئلة الشائعة',
                        'show_icon' => true,
                        'open_first' => true,
                        'allow_multiple_open' => false,
                        'full_width' => true,
                    ],
                ],
                [
                    'type' => 'prisma_cta',
                    'data' => [
                        'title' => 'جاهز للحجز؟',
                        'subtitle' => 'احجز الآن واحصل على خصم 10% على أول تحليل لك',
                        'button_text' => 'احجز عبر الواتساب',
                        'button_url' => 'https://wa.me/' . $this->getSiteSetting('contact_whatsapp', '966500000000'),
                        'button_icon' => 'whatsapp',
                        'rounded_corners' => true,
                        'full_width' => false,
                        'margin_top' => true,
                    ],
                ],
            ],
            'is_published' => true,
            'is_homepage' => true,
        ]);
    }
    
    private function getSiteSetting(string $key, $default = null)
    {
        try {
            return app(\App\Settings\SiteSettings::class)->$key ?? $default;
        } catch (\Exception $e) {
            return $default;
        }
    }
}
