<?php

namespace App\Livewire;

use Livewire\Component;

class PackageModal extends Component
{
    public $isOpen = false;
    public $package = null;
    public $name = '';
    public $phone = '';
    public $note = '';

    protected $listeners = ['openPackageModal'];

    public function openPackageModal($packageData)
    {
        $this->package = $packageData;
        $this->isOpen = true;
    }

    public function closeModal()
    {
        $this->isOpen = false;
        $this->reset(['name', 'phone', 'note']);
    }

    public function submitBooking()
    {
        $this->validate([
            'name' => 'required|string|min:3',
            'phone' => 'required|string|min:10',
        ]);

        // Here you would typically save the booking to database
        // For now, we'll just show a success message
        
        session()->flash('booking_success', 'تم إرسال طلبك بنجاح! سنتواصل معك قريباً.');
        
        $this->closeModal();
    }

    public function getWhatsAppUrl()
    {
        $text = "مرحباً، أود الحجز:\n";
        $text .= "الباقة: " . ($this->package['title'] ?? '') . "\n";
        $text .= "الاسم: " . ($this->name ?: '—') . "\n";
        $text .= "الجوال: " . ($this->phone ?: '—');
        
        if ($this->note) {
            $text .= "\nملاحظة: " . $this->note;
        }

        $whatsappNumber = '966500000000'; // Replace with actual number
        return 'https://wa.me/' . $whatsappNumber . '?text=' . urlencode($text);
    }

    public function render()
    {
        return view('livewire.package-modal');
    }
}
