<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;

class Page extends Model
{
    use HasFactory, SoftDeletes, \Spatie\Translatable\HasTranslations;

    public $translatable = ['title', 'content', 'custom_html', 'meta_title', 'meta_description'];

    protected $fillable = [
        'title',
        'slug',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'content',
        'custom_html',
        'is_published',
        'is_homepage',
        'sort_order',
    ];

    protected $casts = [
        'content' => 'array',
        'meta_keywords' => 'array',
        'is_published' => 'boolean',
        'is_homepage' => 'boolean',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($page) {
            if (empty($page->slug)) {
                $page->slug = Str::slug($page->title);
            }
        });

        static::updating(function ($page) {
            if ($page->isDirty('title') && empty($page->slug)) {
                $page->slug = Str::slug($page->title);
            }
        });
    }

    public function getRouteKeyName()
    {
        return 'slug';
    }

    public function scopePublished($query)
    {
        return $query->where('is_published', true);
    }

    public function scopeHomepage($query)
    {
        return $query->where('is_homepage', true);
    }
}
