<?php

namespace App\Settings;

use Spatie\LaravelSettings\Settings;

class SiteSettings extends Settings
{
    // Branding
    public string $site_name;
    public ?string $logo_light;
    public ?string $logo_dark;
    public ?string $favicon;
    
    // Design System - Prisma Theme
    public string $color_primary;
    public string $color_secondary;
    public string $color_accent;
    public string $color_light;
    public string $color_text;
    public string $footer_bg;

    // Navbar
    public string $navbar_theme; // 'dark' or 'light'
    public string $navbar_bg_color;
    
    // Typography
    public string $font_family;
    public string $font_heading;
    public int $base_size;
    public string $direction;
    
    // Contact Info
    public ?string $contact_phone;
    public ?string $contact_email;
    public ?string $contact_address;
    public ?string $contact_whatsapp;
    public ?string $working_hours;
    
    // Social Links
    public ?string $social_facebook;
    public ?string $social_twitter;
    public ?string $social_instagram;
    public ?string $social_linkedin;
    public ?string $social_youtube;
    public ?string $social_snapchat;
    public ?string $social_tiktok;
    
    // Footer
    public ?string $copyright_text;
    
    // SEO Global
    public ?string $meta_title;
    public ?string $meta_description;
    public ?string $meta_keywords;
    public ?string $google_analytics;
    public ?string $facebook_pixel;
    
    // Homepage Sections
    public bool $show_hero;
    public bool $show_categories;
    public bool $show_packages_99;
    public bool $show_packages_199;
    public bool $show_packages_299;
    public bool $show_about;
    public bool $show_services;
    public bool $show_faq;
    public bool $show_stats;
    
    // Hero Section
    public ?string $hero_title;
    public ?string $hero_subtitle;
    public ?string $hero_cta_text;
    public ?string $hero_cta_url;
    public ?string $hero_background;
    
    // Stats Section
    public ?string $stat_1_value;
    public ?string $stat_1_label;
    public ?string $stat_2_value;
    public ?string $stat_2_label;
    public ?string $stat_3_value;
    public ?string $stat_3_label;
    
    // About Section
    public ?string $about_title;
    public ?string $about_description;
    public ?string $about_image;
    
    // Promotion Banner
    public ?string $promo_badge_text;
    public ?string $promo_title;
    public ?string $promo_subtitle;

    // Booking & Package Page Settings
    public bool $show_booking_form;
    public bool $show_whatsapp_booking;
    public bool $show_credit_payment;
    public bool $show_installment_note;

    public ?string $booking_btn_text;
    public ?string $whatsapp_btn_text;
    public ?string $credit_btn_text;

    public ?string $booking_form_name_label;
    public ?string $booking_form_name_placeholder;
    public ?string $booking_form_phone_label;
    public ?string $booking_form_phone_placeholder;
    public ?string $booking_form_note_label;
    public ?string $booking_form_note_placeholder;

    public ?string $whatsapp_message_template;
    public ?string $installment_note_text;
    public ?string $installment_note_text_en;
    public ?string $booking_success_message;

    public ?string $package_page_title;
    public ?string $package_page_subtitle;

    public static function group(): string
    {
        return 'site';
    }

    public static function defaults(): array
    {
        return [
            'site_name' => 'مختبرات بريزما الطبية',
            'logo_light' => null,
            'logo_dark' => null,
            'favicon' => null,
            'color_primary' => '#1A365D',
            'color_secondary' => '#00A0B0',
            'color_accent' => '#2D9CDB',
            'color_light' => '#F8FAFC',
            'color_text' => '#334155',
            'footer_bg' => '#1A365D',
            'navbar_theme' => 'dark',
            'navbar_bg_color' => '#0a0a0a',
            'font_family' => 'Cairo',
            'font_heading' => 'Cairo',
            'base_size' => 16,
            'direction' => 'rtl',
            'contact_phone' => '920000000',
            'contact_email' => 'info@prisma.sa',
            'contact_address' => 'الرياض، المملكة العربية السعودية',
            'contact_whatsapp' => '966500000000',
            'working_hours' => '24 ساعة',
            'copyright_text' => null,
            'meta_title' => 'مختبرات بريزما الطبية - فحوصات معتمدة ونتائج دقيقة',
            'meta_description' => 'مختبرات بريزما الطبية تقدم فحوصات معتمدة ونتائج دقيقة بأسعار تنافسية. خدمة السحب المنزلي مجاناً.',
            'meta_keywords' => 'مختبر, تحاليل, فحوصات طبية, بريزما, الرياض',
            'google_analytics' => null,
            'facebook_pixel' => null,
            'social_youtube' => null,
            'show_hero' => true,
            'show_categories' => true,
            'show_packages_99' => true,
            'show_packages_199' => true,
            'show_packages_299' => true,
            'show_about' => true,
            'show_services' => true,
            'show_faq' => true,
            'show_stats' => true,
            'hero_title' => 'صحتك تبدأ بفحص دقيق',
            'hero_subtitle' => 'نتائج موثوقة خلال 24 ساعة مع خدمة السحب المنزلي المجانية',
            'hero_cta_text' => 'احجز الآن',
            'hero_cta_url' => '#packages',
            'hero_background' => null,
            'stat_1_value' => '24',
            'stat_1_label' => 'ساعة نتائج',
            'stat_2_value' => '100%',
            'stat_2_label' => 'معتمد',
            'stat_3_value' => 'مجاناً',
            'stat_3_label' => 'السحب المنزلي',
            'about_title' => 'مختبرات بريزما الطبية – شريكك الصحي الموثوق',
            'about_description' => 'مختبرات بريزما الطبية هي مختبر تحاليل معتمد يقدّم خدمات مخبرية متكاملة باستخدام أحدث الأجهزة الطبية، وبإشراف نخبة من المختصين، مع الالتزام بأعلى معايير الجودة والدقة.',
            'about_image' => null,
            'promo_badge_text' => 'عروض الموسم المميزة',
            'promo_title' => 'باقات مختبرات بريزما',
            'promo_subtitle' => 'استفد من عرض: اختر باقتين واحصل على الثالثة مجاناً!',
            'show_booking_form' => true,
            'show_whatsapp_booking' => true,
            'show_credit_payment' => false,
            'show_installment_note' => true,
            'booking_btn_text' => 'احجز مجاناً الآن',
            'whatsapp_btn_text' => 'احجز عبر واتساب',
            'credit_btn_text' => 'احجز بالدفع (تمارا / تابي / بطاقة)',
            'booking_form_name_label' => 'الاسم (مطلوب)',
            'booking_form_name_placeholder' => 'أدخل اسمك',
            'booking_form_phone_label' => 'رقم الجوال (مطلوب)',
            'booking_form_phone_placeholder' => '05xxxxxxxx',
            'booking_form_note_label' => 'ملاحظة (اختياري)',
            'booking_form_note_placeholder' => 'أي ملاحظات إضافية...',
            'whatsapp_message_template' => "مرحباً، أود الحجز:\nالباقة: {package}\nالاسم: {name}\nالجوال: {phone}",
            'installment_note_text' => 'قسّط مبلغ الباقة على 4 أقساط بدون فوائد عبر تمارا أو تابي',
            'installment_note_text_en' => 'Split your payment into 4 interest-free installments via Tamara or Tabby',
            'booking_success_message' => 'تم إرسال طلبك بنجاح! سنتواصل معك قريباً.',
            'package_page_title' => 'باقات الفحوصات الطبية',
            'package_page_subtitle' => 'باقات فحص شاملة بأفضل الأسعار — نتائج دقيقة ومعتمدة من وزارة الصحة مع خدمة السحب المنزلي المجانية',
        ];
    }
}
