<?php

namespace App\Support;

/**
 * Shared icon options for Filament page builder blocks.
 * Use "Icon library" (FontAwesome/Heroicons) or "Custom image" upload.
 */
class IconOptions
{
    public static function iconTypeField(string $prefix = ''): array
    {
        $key = $prefix ? "{$prefix}.icon_type" : 'icon_type';
        return [
            \Filament\Forms\Components\Select::make($key)
                ->label(__('Icon source'))
                ->options([
                    'library' => __('Icon library (FontAwesome)'),
                    'image'   => __('Custom image upload'),
                ])
                ->default('library')
                ->live()
                ->required(),
        ];
    }

    public static function fontAwesomeOptions(): array
    {
        return [
            // Medical / Lab
            'fas fa-tint' => 'Blood',
            'fas fa-vial' => 'Vial',
            'fas fa-dna' => 'DNA',
            'fas fa-virus' => 'Virus',
            'fas fa-baby' => 'Baby',
            'fas fa-heartbeat' => 'Heartbeat',
            'fas fa-pills' => 'Pills',
            'fas fa-heart' => 'Heart',
            'fas fa-flask' => 'Flask',
            'fas fa-microscope' => 'Microscope',
            'fas fa-syringe' => 'Syringe',
            'fas fa-ambulance' => 'Ambulance',
            'fas fa-hospital' => 'Hospital',
            'fas fa-user-md' => 'Doctor',
            'fas fa-stethoscope' => 'Stethoscope',
            'fas fa-file-medical' => 'Medical Report',
            'fas fa-thermometer' => 'Thermometer',
            'fas fa-band-aid' => 'Band-aid',
            'fas fa-first-aid' => 'First aid',
            'fas fa-lungs' => 'Lungs',
            'fas fa-brain' => 'Brain',
            // Services / General
            'fas fa-home' => 'Home',
            'fas fa-truck' => 'Truck',
            'fas fa-clock' => 'Clock',
            'fas fa-calendar-check' => 'Calendar',
            'fas fa-phone' => 'Phone',
            'fas fa-mobile-alt' => 'Mobile',
            'fas fa-envelope' => 'Envelope',
            'fas fa-map-marker-alt' => 'Map pin',
            'fas fa-award' => 'Award',
            'fas fa-certificate' => 'Certificate',
            'fas fa-check-circle' => 'Check',
            'fas fa-shield-alt' => 'Shield',
            'fas fa-star' => 'Star',
            'fas fa-thumbs-up' => 'Thumbs up',
            'fas fa-apple-alt' => 'Apple',
        ];
    }

    public static function iconLibrarySelect(string $name = 'icon', string $prefix = '', string $default = 'fas fa-flask')
    {
        $key = $prefix ? "{$prefix}.{$name}" : $name;
        return \Filament\Forms\Components\Select::make($key)
            ->label(__('Icon'))
            ->options(static::fontAwesomeOptions())
            ->default($default)
            ->searchable()
            ->helperText(__('Choose from FontAwesome icons. More at fontawesome.com/icons'));
    }

    public static function iconImageUpload(string $name = 'icon_image', string $prefix = '', string $directory = 'block-icons')
    {
        $key = $prefix ? "{$prefix}.{$name}" : $name;
        return \Filament\Forms\Components\FileUpload::make($key)
            ->label(__('Icon image'))
            ->image()
            ->directory($directory)
            ->visibility('public')
            ->imageEditor()
            ->maxSize(1024)
            ->helperText(__('Upload a small image (e.g. PNG/SVG) to use as icon'));
    }
}
