<?php

use Spatie\LaravelSettings\Migrations\SettingsBlueprint;
use Spatie\LaravelSettings\Migrations\SettingsMigrator;

return [
    /*
     * Each settings class used in your application must be registered, you can
     * put them (manually) here.
     */
    'settings' => [
        \App\Settings\SiteSettings::class,
    ],

    /*
     * In these directories settings migrations will be stored and ran when migrating. A settings
     * migration created via the make:settings-migration command will be stored in the first path or
     * a custom defined path when running the command.
     */
    'migrations_paths' => [
        database_path('settings-migrations'),
    ],

    /*
     * When no repository was set for a settings class, the following repository
     * will be used for loading and saving settings.
     */
    'default_repository' => 'database',

    /*
     * Settings will be stored and loaded from these repositories.
     */
    'repositories' => [
        'database' => [
            'type' => Spatie\LaravelSettings\SettingsRepositories\DatabaseSettingsRepository::class,
            'model' => Spatie\LaravelSettings\Models\SettingsProperty::class,
            'table' => 'settings',
        ],
        'redis' => [
            'type' => Spatie\LaravelSettings\SettingsRepositories\RedisSettingsRepository::class,
        ],
    ],

    /*
     * The encoder and decoder will convert values to and from a string representation
     * when loading and saving settings to the database. By default, JSON is used.
     */
    'encoder' => null,
    'decoder' => null,

    /*
     * The contents of settings classes can be cached through your application, settings
     * will be stored within a provided Laravel store.
     */
    'cache' => [
        'enabled' => env('SETTINGS_CACHE_ENABLED', false),
        'store' => null,
        'prefix' => 'settings',
        'ttl' => null,
    ],

    /*
     * These global casts will be automatically used when a property within a settings
     * class isn't a default PHP type.
     */
    'global_casts' => [
        DateTime::class => Spatie\LaravelSettings\SettingsCasts\DateTimeInterfaceCast::class,
        DateTimeImmutable::class => Spatie\LaravelSettings\SettingsCasts\DateTimeInterfaceCast::class,
        DateTimeInterface::class => Spatie\LaravelSettings\SettingsCasts\DateTimeInterfaceCast::class,
    ],

    /*
     * Profile determine how properties are mapped into the database. By default
     * properties are stored as it is in the database, this means a property type
     * should be a PHP primitive type. When using the `dto` profile, properties
     * can be mapped to DTO's which will be automatically serialized into JSON.
     */
    'profiles' => [
        'default' => [
            'type' => Spatie\LaravelSettings\SettingsConfig\SettingsProfile::class,
            'properties' => null,
        ],
    ],

    /*
     * The settings migrator used when creating a new settings migration. This
     * migrator will be used to create the settings table and columns.
     */
    'migrator' => SettingsMigrator::class,

    /*
     * The settings blueprint used when creating a new settings migration. This
     * blueprint will be used to define the settings table schema.
     */
    'blueprint' => SettingsBlueprint::class,
];
