<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('package_sections', function (Blueprint $table) {
            $table->id();
            $table->foreignId('package_id')->constrained()->cascadeOnDelete();
            $table->string('name')->nullable(); // Primary Name (Arabic)
            $table->json('name_translations')->nullable(); // Translations (English, etc.)
            $table->integer('sort_order')->default(0);
            $table->timestamps();
        });

        Schema::create('package_section_test', function (Blueprint $table) {
            $table->id();
            $table->foreignId('package_section_id')->constrained()->cascadeOnDelete();
            $table->foreignId('test_id')->constrained()->cascadeOnDelete();
            $table->integer('sort_order')->default(0);
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('package_section_test');
        Schema::dropIfExists('package_sections');
    }
};
