<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Create admin user if not exists
        if (!User::where('email', 'admin@prismalab.com')->exists()) {
            User::factory()->create([
                'name' => 'Admin User',
                'email' => 'admin@prismalab.com',
                'password' => bcrypt('password'),
            ]);
        }

        // Run initial data seeders
        $this->call([
            InitialDataSeeder::class,
            PackageSeeder::class,
        ]);
    }
}
