<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\Navigation;
use App\Models\Page;
use App\Settings\SiteSettings;
use Illuminate\Database\Seeder;

class InitialDataSeeder extends Seeder
{
    public function run(): void
    {
        // Create default site settings
        $settings = app(SiteSettings::class);
        $settings->site_name = 'مختبرات بريزما الطبية';
        $settings->font_family = 'Cairo';
        $settings->font_heading = 'Cairo';
        $settings->base_size = 16;
        $settings->direction = 'rtl';
        
        // Prisma Color Palette
        $settings->color_primary = '#1A365D';
        $settings->color_secondary = '#00A0B0';
        $settings->color_accent = '#2D9CDB';
        $settings->color_light = '#F8FAFC';
        $settings->color_text = '#334155';
        $settings->footer_bg = '#1A365D';
        
        // Contact Info
        $settings->contact_phone = '920000000';
        $settings->contact_email = 'info@prisma.sa';
        $settings->contact_address = 'جدة، المملكة العربية السعودية';
        $settings->contact_whatsapp = '966500000000';
        $settings->working_hours = '24 ساعة';
        
        // SEO
        $settings->meta_title = 'مختبرات بريزما الطبية - فحوصات معتمدة ونتائج دقيقة';
        $settings->meta_description = 'مختبرات بريزما الطبية تقدم فحوصات معتمدة ونتائج دقيقة بأسعار تنافسية. خدمة السحب المنزلي مجاناً.';
        $settings->meta_keywords = 'مختبر, تحاليل, فحوصات طبية, بريزما, جدة, السعودية';
        
        // Sections
        $settings->show_hero = true;
        $settings->show_categories = true;
        $settings->show_packages_99 = true;
        $settings->show_packages_199 = true;
        $settings->show_packages_299 = true;
        $settings->show_about = true;
        $settings->show_services = true;
        $settings->show_faq = true;
        $settings->show_stats = true;
        
        // Hero
        $settings->hero_title = 'صحتك تبدأ بفحص دقيق';
        $settings->hero_subtitle = 'نتائج موثوقة خلال 24 ساعة مع خدمة السحب المنزلي المجانية';
        $settings->hero_cta_text = 'احجز الآن';
        $settings->hero_cta_url = '#packages';
        
        // Stats
        $settings->stat_1_value = '24';
        $settings->stat_1_label = 'ساعة نتائج';
        $settings->stat_2_value = '100%';
        $settings->stat_2_label = 'معتمد';
        $settings->stat_3_value = 'مجاناً';
        $settings->stat_3_label = 'السحب المنزلي';
        
        // About
        $settings->about_title = 'مختبرات بريزما الطبية – شريكك الصحي الموثوق';
        $settings->about_description = 'مختبرات بريزما الطبية هي مختبر تحاليل معتمد يقدّم خدمات مخبرية متكاملة باستخدام أحدث الأجهزة الطبية، وبإشراف نخبة من المختصين، مع الالتزام بأعلى معايير الجودة والدقة.';
        
        // Promo
        $settings->promo_badge_text = 'عروض الموسم المميزة';
        $settings->promo_title = 'باقات مختبرات بريزما';
        $settings->promo_subtitle = 'استفد من عرض: اختر باقتين واحصل على الثالثة مجاناً!';
        
        $settings->save();

        // Create Categories
        $categories = [
            ['name' => 'تحاليل الدم', 'slug' => 'blood-tests', 'icon' => 'fas fa-tint', 'sort_order' => 1],
            ['name' => 'تحاليل البول', 'slug' => 'urine-tests', 'icon' => 'fas fa-vial', 'sort_order' => 2],
            ['name' => 'تحاليل هرمونية', 'slug' => 'hormone-tests', 'icon' => 'fas fa-dna', 'sort_order' => 3],
            ['name' => 'تحاليل فيروسات', 'slug' => 'virus-tests', 'icon' => 'fas fa-virus', 'sort_order' => 4],
            ['name' => 'باقات الحوامل', 'slug' => 'pregnancy-packages', 'icon' => 'fas fa-baby', 'sort_order' => 5],
            ['name' => 'باقات السكر', 'slug' => 'diabetes-packages', 'icon' => 'fas fa-heartbeat', 'sort_order' => 6],
            ['name' => 'باقات فيتامينات', 'slug' => 'vitamin-packages', 'icon' => 'fas fa-pills', 'sort_order' => 7],
            ['name' => 'باقات أمراض القلب', 'slug' => 'heart-packages', 'icon' => 'fas fa-heart', 'sort_order' => 8],
        ];

        foreach ($categories as $cat) {
            if (!Category::where('slug', $cat['slug'])->exists()) {
                Category::create($cat + ['is_active' => true]);
            }
        }

        // Create Header Navigation
        $headerNavItems = [
            ['title' => 'الرئيسية', 'url' => '/', 'sort_order' => 1],
            ['title' => 'الباقات', 'url' => '/packages', 'sort_order' => 2],
            ['title' => 'من نحن', 'url' => '#about', 'sort_order' => 3],
            ['title' => 'خدماتنا', 'url' => '#services', 'sort_order' => 4],
            ['title' => 'تواصل معنا', 'url' => '#faq', 'sort_order' => 5],
        ];

        foreach ($headerNavItems as $item) {
            if (!Navigation::where('title', $item['title'])->where('location', 'header')->exists()) {
                Navigation::create([
                    'title' => $item['title'],
                    'url' => $item['url'],
                    'location' => 'header',
                    'type' => 'custom',
                    'target' => '_self',
                    'sort_order' => $item['sort_order'],
                    'is_active' => true,
                ]);
            }
        }

        // Create Footer Navigation
        $footerNavItems = [
            ['title' => 'سياسة الخصوصية', 'url' => '#', 'sort_order' => 1],
            ['title' => 'الشروط والأحكام', 'url' => '#', 'sort_order' => 2],
            ['title' => 'الأسئلة الشائعة', 'url' => '#faq', 'sort_order' => 3],
        ];

        foreach ($footerNavItems as $item) {
            if (!Navigation::where('title', $item['title'])->where('location', 'footer')->exists()) {
                Navigation::create([
                    'title' => $item['title'],
                    'url' => $item['url'],
                    'location' => 'footer',
                    'type' => 'custom',
                    'target' => '_self',
                    'sort_order' => $item['sort_order'],
                    'is_active' => true,
                ]);
            }
        }

        $this->command->info('Initial data seeded successfully!');
    }
}
