<?php

function looksEphemeralKey(string $key): bool
{
    return (bool) preg_match('/^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i', $key)
        || (bool) preg_match('/^[A-Za-z0-9_-]{20,}$/', $key);
}

function isEphemeralFileMap(array $value): bool
{
    if (empty($value) || array_is_list($value)) return false;
    foreach ($value as $key => $item) {
        if (!is_string($key) || !looksEphemeralKey($key)) return false;
    }
    return true;
}

function normalizePreviewData(mixed $value)
{
    if (!is_array($value)) return $value;

    if (isEphemeralFileMap($value)) {
        $normalized = array_values(array_filter(array_map(
            fn (mixed $item) => normalizePreviewData($item),
            array_values($value)
        ), fn (mixed $item) => $item !== null && $item !== ''));

        // THIS IS THE SUSPECTED BUG
        return count($normalized) === 1 ? ($normalized[0] ?? null) : $normalized;
    }

    foreach ($value as $key => $item) {
        $value[$key] = normalizePreviewData($item);
    }

    return $value;
}

$singleBlockData = [
    'content' => [
        '01KJ06QZAM3G89YC95V1B6PCXF' => [
            'type' => 'prisma_hero',
            'data' => [
                'title' => 'Test Title',
            ],
        ]
    ]
];

echo "Single block normalization result:\n";
$normalized = normalizePreviewData($singleBlockData);
print_r($normalized);

$multiBlockData = [
    'content' => [
        '01KJ06...' => ['type' => 'hero'],
        '01KJ07...' => ['type' => 'about'],
    ]
];

echo "\nMulti block normalization result:\n";
$normalized = normalizePreviewData($multiBlockData);
print_r($normalized);
