@props(['slides' => []])

@php
    $resolveUploadValue = function (mixed $value) use (&$resolveUploadValue): ?string {
        if (is_string($value) && $value !== '') {
            return $value;
        }

        if (! is_array($value)) {
            return null;
        }

        foreach (['path', 'url', 'temporaryUrl', 'preview_url'] as $key) {
            if (! empty($value[$key]) && is_string($value[$key])) {
                return $value[$key];
            }
        }

        foreach ($value as $item) {
            $resolved = $resolveUploadValue($item);
            if ($resolved) {
                return $resolved;
            }
        }

        return null;
    };

    $toImageUrl = function (mixed $value) use ($resolveUploadValue): ?string {
        $resolved = $resolveUploadValue($value);
        if (! $resolved) {
            return null;
        }

        if (str_starts_with($resolved, 'http://') || str_starts_with($resolved, 'https://') || str_starts_with($resolved, 'data:')) {
            return $resolved;
        }

        if (str_starts_with($resolved, '/storage/')) {
            return url($resolved);
        }

        return asset('storage/' . ltrim($resolved, '/'));
    };
@endphp

@if(!empty($slides))
<div class="relative bg-gray-900 overflow-hidden" x-data="{ currentSlide: 0, totalSlides: {{ count($slides) }} }" x-init="setInterval(() => { currentSlide = (currentSlide + 1) % totalSlides }, 6000)">
    @foreach($slides as $index => $slide)
        @php
            $slideImageUrl = $toImageUrl($slide['image'] ?? null);
        @endphp
        @if($slide['is_active'] ?? true)
        <div x-show="currentSlide === {{ $index }}"
             x-transition:enter="transition ease-out duration-700"
             x-transition:enter-start="opacity-0 transform scale-105"
             x-transition:enter-end="opacity-100 transform scale-100"
             x-transition:leave="transition ease-in duration-500"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0"
             class="absolute inset-0"
             style="display: {{ $index === 0 ? 'block' : 'none' }};">
            
            {{-- Background Image --}}
            <div class="absolute inset-0">
                @if($slideImageUrl)
                    <img src="{{ $slideImageUrl }}" 
                         alt="{{ $slide['title'] ?? '' }}"
                         class="w-full h-full object-cover">
                @else
                    <div class="w-full h-full bg-gradient-to-br from-slate-800 via-slate-700 to-slate-900"></div>
                @endif
                <div class="absolute inset-0 bg-gradient-to-r from-gray-900/90 via-gray-900/70 to-gray-900/30"></div>
            </div>
            
            {{-- Content --}}
            @php

                $title = $data['title'] ?? "";
                $subtitle = $data['subtitle'] ?? "";
                $buttonText = $data['button_text'] ?? "";
                $buttonUrl = $data['button_url'] ?? "";
            @endphp
            <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 h-[600px] flex items-center">
                <div class="max-w-2xl">
                    <h2 class="text-4xl md:text-5xl lg:text-6xl font-bold text-white mb-6 leading-tight animate-fade-in-up">
                        {{ $title }}
                    </h2>
                    @if(!empty($subtitle))
                        <p class="text-lg md:text-xl text-gray-200 mb-8 animate-fade-in-up" style="animation-delay: 0.2s;">
                            {{ $subtitle }}
                        </p>
                    @endif
                    @if(!empty($buttonText) && !empty($buttonUrl))
                        <a href="{{ $buttonUrl }}" 
                           class="inline-flex items-center px-8 py-4 bg-theme-primary text-white font-semibold rounded-lg hover:bg-theme-primary-dark transition-all transform hover:scale-105 animate-fade-in-up shadow-lg shadow-primary-500/30"
                           style="animation-delay: 0.4s;">
                            {{ $buttonText }}
                            <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                            </svg>
                        </a>
                    @endif
                </div>
            </div>
        </div>
        @endif
    @endforeach
    
    {{-- Slide Indicators --}}
    @if(count($slides) > 1)
    <div class="absolute bottom-8 left-1/2 transform -translate-x-1/2 flex space-x-3">
        @foreach($slides as $index => $slide)
            @if($slide['is_active'] ?? true)
            <button @click="currentSlide = {{ $index }}" 
                    :class="{'bg-white w-8': currentSlide === {{ $index }}, 'bg-white/50 w-3': currentSlide !== {{ $index }}}"
                    class="h-3 rounded-full transition-all duration-300 hover:bg-white">
            </button>
            @endif
        @endforeach
    </div>
    @endif
    
    {{-- Navigation Arrows --}}
    @if(count($slides) > 1)
    <button @click="currentSlide = (currentSlide - 1 + totalSlides) % totalSlides"
            class="absolute left-4 top-1/2 transform -translate-y-1/2 p-3 bg-white/10 backdrop-blur-sm rounded-full text-white hover:bg-white/20 transition-colors">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
        </svg>
    </button>
    <button @click="currentSlide = (currentSlide + 1) % totalSlides"
            class="absolute right-4 top-1/2 transform -translate-y-1/2 p-3 bg-white/10 backdrop-blur-sm rounded-full text-white hover:bg-white/20 transition-colors">
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
        </svg>
    </button>
    @endif
</div>
@endif

@push('styles')
<style>
@keyframes fade-in-up {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}
.animate-fade-in-up {
    animation: fade-in-up 0.8s ease-out forwards;
}
</style>
@endpush
