@php
$siteSettings = $siteSettings ?? (function () { try { return app(\App\Settings\SiteSettings::class); } catch (\Throwable $e) { return new \stdClass(); } })();
$showFromDb = $data['show_from_database'] ?? true;
$limit = $data['limit'] ?? 8;
$showNames = $data['show_names'] ?? true;
$cardStyle = $data['card_style'] ?? true;
$customCategories = $data['custom_categories'] ?? [];

$categories = $showFromDb ? \App\Models\Category::active()->orderBy('sort_order')->take($limit)->get() : collect($customCategories);
@endphp

@if($categories->count() > 0)
<section class="categories" style="padding: 30px 20px; max-width: 1000px; margin: -50px auto 0; position: relative; z-index: 10;">
    <div style="{{ $cardStyle ? 'background: white; border-radius: var(--pr-radius-lg); box-shadow: var(--pr-shadow-card); padding: 24px 28px;' : '' }} display: grid; grid-template-columns: repeat(auto-fit, minmax(100px, 1fr)); gap: 16px; justify-items: center;">
        @foreach($categories as $category)
            @php
                $url = $showFromDb ? route('packages.index', ['category' => $category->slug]) : ($category['url'] ?? '#');
                $icon = $showFromDb ? ($category->icon ?? 'fas fa-flask') : ($category['icon'] ?? 'fas fa-flask');
                $iconType = $showFromDb ? 'library' : ($category['icon_type'] ?? 'library');
                $iconImage = $showFromDb ? null : ($category['icon_image'] ?? null);
                
                if ($showFromDb) {
                    $name = $category->name;
                } else {
                    $name = $data['name'] ?? "";
                }
            @endphp
            <a href="{{ $url }}" class="category-item" style="display: flex; flex-direction: column; align-items: center; gap: 10px; text-decoration: none; padding: 12px; transition: var(--transition); border-radius: 12px; min-width: 90px;">
                <div style="width: 52px; height: 52px; border-radius: 50%; background: linear-gradient(135deg, {{ $siteSettings->color_secondary }} 0%, {{ $siteSettings->color_accent }} 100%); display: flex; align-items: center; justify-content: center; font-size: 1.3rem; color: white; box-shadow: 0 4px 15px rgba(0, 160, 176, 0.3); transition: var(--transition);">
                    @if($iconType === 'image' && $iconImage)
                        <img src="{{ \Illuminate\Support\Facades\Storage::url($iconImage) }}" alt="" style="width: 28px; height: 28px; object-fit: contain;">
                    @else
                        <i class="{{ $icon }}"></i>
                    @endif
                </div>
                @if($showNames)
                <span style="font-size: 0.75rem; color: var(--pr-primary); font-weight: 700; text-align: center;">{{ $name }}</span>
                @endif
            </a>
        @endforeach
    </div>
</section>

<style>
    .category-item:hover {
        transform: translateY(-4px);
    }
    .category-item:hover > div:first-child {
        transform: scale(1.1);
    }
</style>
@endif
