@php

$title = $data['title'] ?? "";
$showIcon = $data['show_icon'] ?? true;
$faqs = $data['faqs'] ?? [
    [
        'question' => 'هل هناك تحضيرات خاصة قبل إجراء التحليل؟',
        'answer' => 'في حالة تحليل السكر التراكمي، لا يوجد تحضيرات خاصة. أما التحاليل الأخرى قد تحتاج إلى صيام حسب نوع التحليل، وسنقوم بإبلاغك بالتعليمات عند الحجز.',
    ],
    [
        'question' => 'هل يمكن إجراء التحليل في المنزل؟',
        'answer' => 'نعم، نقدم خدمة السحب المنزلي المجانية داخل المدينة. سيصلك فريقنا المتخصص في الوقت المناسب لك.',
    ],
    [
        'question' => 'هل التقارير معتمدة؟',
        'answer' => 'نعم، جميع التقارير معتمدة من وزارة الصحة السعودية وتُرسل إلكترونياً فور اكتمالها.',
    ],
];
$openFirst = $data['open_first'] ?? true;
$allowMultiple = $data['allow_multiple_open'] ?? false;
$fullWidth = $data['full_width'] ?? true;

$firstOpen = filter_var($openFirst, FILTER_VALIDATE_BOOLEAN) ? 1 : 'null';
@endphp

<section class="faq-section" style="padding: 100px 0; background: #f8fafc; position: relative;">
    <div style="max-width: 900px; margin: 0 auto; padding: 0 20px;">
        <div style="text-align: center; margin-bottom: 60px;">
            <div style="color: #6366F1; font-weight: 800; font-size: 0.9rem; text-transform: uppercase; letter-spacing: 2px; margin-bottom: 15px;">مركز المساعدة</div>
            <h2 style="font-size: 2.8rem; font-weight: 800; color: #1A365D; margin-bottom: 15px; font-family: 'Cairo', sans-serif;">
                {{ $title }}
            </h2>
            <div style="width: 60px; height: 4px; background: #00A0B0; margin: 0 auto; border-radius: 2px;"></div>
        </div>
        
        <div x-data="{ openFaq: {{ $firstOpen }} }" style="display: flex; flex-direction: column; gap: 20px;">
            @foreach($faqs as $faq)
            @php $iteration = $loop->iteration; @endphp
            <div class="faq-item" 
                 :style="openFaq === {{ $iteration }} ? 'border-right: 5px solid #00A0B0; box-shadow: 0 15px 40px rgba(26, 54, 93, 0.08);' : 'border-right: 5px solid transparent;' "
                 style="background: white; border-radius: 16px; transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); overflow: hidden; box-shadow: 0 10px 30px rgba(0,0,0,0.02);">
                <button @click="openFaq = (openFaq === {{ $iteration }} ? null : {{ $iteration }})" 
                        style="width: 100%; padding: 25px 30px; text-align: right; border: none; background: none; cursor: pointer; display: flex; align-items: center; justify-content: space-between;">
                    <span style="font-weight: 800; color: #1A365D; font-size: 1.15rem;">{{ $data['question'] ?? "" }}</span>
                    <div style="width: 32px; height: 32px; border-radius: 50%; background: #f0f7f7; display: flex; align-items: center; justify-content: center; transition: all 0.3s;"
                         :style="openFaq === {{ $iteration }} ? 'background: #00A0B0; color: white; transform: rotate(180deg);' : 'color: #00A0B0;'">
                        <i class="fas fa-chevron-down" style="font-size: 0.8rem;"></i>
                    </div>
                </button>
                <div x-show="openFaq === {{ $iteration }}" 
                     x-transition:enter="faq-content-enter"
                     style="padding: 0 30px 25px; color: #64748b; line-height: 1.8; font-size: 1.05rem; font-weight: 500;">
                    {{ $data['answer'] ?? "" }}
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>

<style>
    @keyframes faq-content-enter {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    .faq-content-enter { animation: faq-content-enter 0.3s ease-out forwards; }
    .faq-item:hover { transform: translateY(-4px); box-shadow: 0 15px 40px rgba(26, 54, 93, 0.05); }
</style>
