@php

$title = $data['title'] ?? "";
$subtitle = $data['subtitle'] ?? "";

$services = $data['services'] ?? [
    ['title' => 'تحاليل الدم الشاملة', 'description' => 'فحوصات دم دقيقة تشمل جميع المؤشرات الحيوية مع تقارير مفصلة', 'icon' => 'fas fa-flask'],
    ['title' => 'تحاليل البول والبراز', 'description' => 'تحاليل دقيقة للكشف عن الأمراض والالتهابات والأملاح', 'icon' => 'fas fa-vial'],
    ['title' => 'تحاليل هرمونية', 'description' => 'فحص شامل لمناعة الجسم والأجسام المضادة لمختلف الأمراض', 'icon' => 'fas fa-dna'],
    ['title' => 'سحب منزلي مجاني', 'description' => 'نأتيك أينما كنت داخل المدينة مع خدمة سحب عينات مجانية', 'icon' => 'fas fa-home'],
];
$showIconBg = $data['show_icon_background'] ?? true;
$cardBorder = $data['card_border'] ?? true;
$centerAlign = $data['center_align'] ?? true;
@endphp

<section class="services-section" style="padding: 100px 0; background: white; position: relative; overflow: hidden;">
    {{-- Soft Pattern Background --}}
    <div style="position: absolute; inset: 0; opacity: 0.02; background-image: url('data:image/svg+xml,%3Csvg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"%3E%3Cg fill=\"%2300A0B0\" fill-opacity=\"0.4\" fill-rule=\"evenodd\"%3E%3Ccircle cx=\"3\" cy=\"3\" r=\"3\"/%3E%3Ccircle cx=\"13\" cy=\"13\" r=\"3\"/%3E%3C/g%3E%3C/svg%3E');"></div>

    <div style="max-width: 1200px; margin: 0 auto; padding: 0 20px; position: relative; z-index: 1;">
        <div style="text-align: center; margin-bottom: 60px;">
            <div style="color: #6366F1; font-weight: 800; font-size: 0.9rem; text-transform: uppercase; letter-spacing: 2px; margin-bottom: 15px;">التميز في الخدمة</div>
            <h2 style="font-size: 2.8rem; font-weight: 800; color: #1A365D; margin-bottom: 15px; font-family: 'Cairo', sans-serif;">
                {{ $title }}
            </h2>
            <div style="width: 60px; height: 4px; background: #00A0B0; margin: 0 auto; border-radius: 2px;"></div>
            <p style="color: #64748b; font-size: 1.15rem; margin-top: 25px; max-width: 700px; margin-left: auto; margin-right: auto; line-height: 1.7;">{{ $subtitle }}</p>
        </div>
        
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 35px;">
            @foreach($services as $service)
            @php
                $iconType = $service['icon_type'] ?? 'library';
                $iconImage = $service['icon_image'] ?? null;
            @endphp
            <div class="service-card" style="background: white; padding: 40px 30px; border-radius: 20px; transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); border: 1px solid #f1f5f9; box-shadow: 0 10px 30px rgba(0,0,0,0.02);">
                <div style="width: 80px; height: 80px; margin-bottom: 30px; border-radius: 22px; background: linear-gradient(135deg, rgba(0, 160, 176, 0.1) 0%, rgba(99, 102, 241, 0.1) 100%); display: flex; align-items: center; justify-content: center; font-size: 2rem; color: #00A0B0;">
                    @if($iconType === 'image' && $iconImage)
                        <img src="{{ \Illuminate\Support\Facades\Storage::url($iconImage) }}" alt="" style="width: 40px; height: 40px; object-fit: contain;">
                    @else
                        <i class="{{ $service['icon'] ?? 'fas fa-flask' }}"></i>
                    @endif
                </div>
                <h3 style="font-size: 1.35rem; font-weight: 800; color: #1A365D; margin-bottom: 15px;">{{ $data['title'] ?? "" }}</h3>
                <p style="color: #64748b; line-height: 1.8; font-size: 1.05rem;">{{ $data['description'] ?? "" }}</p>
                <a href="#" style="display: inline-flex; align-items: center; gap: 8px; margin-top: 25px; color: #00A0B0; font-weight: 700; text-decoration: none; font-size: 0.95rem;">
                    اقرأ المزيد <i class="fas fa-arrow-left"></i>
                </a>
            </div>
            @endforeach
        </div>
    </div>
</section>

<style>
    .service-card:hover {
        transform: translateY(-12px);
        background: white;
        border-color: rgba(0, 160, 176, 0.1);
        box-shadow: 0 30px 60px rgba(26, 54, 93, 0.1);
    }
    .service-card:hover i { transform: scale(1.1); transition: transform 0.3s; }
</style>
