<x-filament-widgets::widget>
    <x-filament::section>
        <div class="flex items-center gap-2 mb-4">
            <x-heroicon-o-bolt class="w-6 h-6 text-primary-600" />
            <h2 class="text-xl font-bold tracking-tight text-gray-950 dark:text-white">وصول سريع</h2>
        </div>
        
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <!-- Site Settings -->
            <a href="{{ route('filament.admin.pages.manage-site-settings') }}" class="flex flex-col items-center justify-center p-6 bg-gray-50 dark:bg-gray-800 rounded-xl border border-gray-200 dark:border-gray-700 hover:border-primary-500 hover:bg-primary-50 dark:hover:bg-primary-900/20 transition-all group">
                <div class="w-12 h-12 rounded-full bg-primary-100 dark:bg-primary-900/50 flex items-center justify-center mb-3 group-hover:scale-110 transition-transform">
                    <x-heroicon-o-cog-6-tooth class="w-6 h-6 text-primary-600 dark:text-primary-400" />
                </div>
                <span class="font-medium text-gray-900 dark:text-white text-center">إعدادات الموقع</span>
            </a>

            <!-- Packages -->
            <a href="{{ route('filament.admin.resources.packages.create') }}" class="flex flex-col items-center justify-center p-6 bg-gray-50 dark:bg-gray-800 rounded-xl border border-gray-200 dark:border-gray-700 hover:border-success-500 hover:bg-success-50 dark:hover:bg-success-900/20 transition-all group">
                <div class="w-12 h-12 rounded-full bg-success-100 dark:bg-success-900/50 flex items-center justify-center mb-3 group-hover:scale-110 transition-transform">
                    <x-heroicon-o-briefcase class="w-6 h-6 text-success-600 dark:text-success-400" />
                </div>
                <span class="font-medium text-gray-900 dark:text-white text-center">إضافة باقة جديدة</span>
            </a>

            <!-- Forms -->
            <a href="{{ route('filament.admin.resources.custom-forms.index') }}" class="flex flex-col items-center justify-center p-6 bg-gray-50 dark:bg-gray-800 rounded-xl border border-gray-200 dark:border-gray-700 hover:border-info-500 hover:bg-info-50 dark:hover:bg-info-900/20 transition-all group">
                <div class="w-12 h-12 rounded-full bg-info-100 dark:bg-info-900/50 flex items-center justify-center mb-3 group-hover:scale-110 transition-transform">
                    <x-heroicon-o-document-text class="w-6 h-6 text-info-600 dark:text-info-400" />
                </div>
                <span class="font-medium text-gray-900 dark:text-white text-center">النماذج المخصصة</span>
            </a>

            <!-- Pages -->
            <a href="{{ route('filament.admin.resources.pages.index') }}" class="flex flex-col items-center justify-center p-6 bg-gray-50 dark:bg-gray-800 rounded-xl border border-gray-200 dark:border-gray-700 hover:border-warning-500 hover:bg-warning-50 dark:hover:bg-warning-900/20 transition-all group">
                <div class="w-12 h-12 rounded-full bg-warning-100 dark:bg-warning-900/50 flex items-center justify-center mb-3 group-hover:scale-110 transition-transform">
                    <x-heroicon-o-document-duplicate class="w-6 h-6 text-warning-600 dark:text-warning-400" />
                </div>
                <span class="font-medium text-gray-900 dark:text-white text-center">إدارة الصفحات</span>
            </a>
        </div>
    </x-filament::section>
</x-filament-widgets::widget>
