<div class="live-builder-container" 
     x-data="{ 
        previewScale: 1,
        sidebarOpen: true,
        showLayers: false
     }"
     style="display: flex; height: 100vh; background: #f4f7f9; overflow: hidden; font-family: 'Cairo', sans-serif;"
>
    <!-- Styles for the Builder UI (High Fidelity) -->
    <style>
        :root {
            --builder-primary: #00A0B0;
            --builder-secondary: #2D9CDB;
            --builder-bg: #f8fafc;
            --builder-sidebar: #ffffff;
            --builder-border: #e2e8f0;
            --builder-text: #1e293b;
        }

        .builder-sidebar {
            width: 360px;
            min-width: 360px;
            background: var(--builder-sidebar);
            border-left: 1px solid var(--builder-border);
            display: flex;
            flex-direction: column;
            box-shadow: 4px 0 15px rgba(0,0,0,0.02);
            z-index: 20;
            transition: transform 0.3s ease;
        }

        .builder-header {
            padding: 16px 20px;
            border-bottom: 1px solid var(--builder-border);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .builder-canvas-wrapper {
            flex: 1;
            display: flex;
            flex-direction: column;
            overflow: hidden;
            position: relative;
        }

        .builder-toolbar {
            height: 56px;
            background: white;
            border-bottom: 1px solid var(--builder-border);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 20px;
            padding: 0 20px;
        }

        .device-toggle {
            display: flex;
            background: #f1f5f9;
            padding: 4px;
            border-radius: 8px;
        }

        .device-btn {
            padding: 6px 12px;
            border-radius: 6px;
            border: none;
            background: transparent;
            color: #64748b;
            cursor: pointer;
            transition: all 0.2s;
        }

        .device-btn.active {
            background: white;
            color: var(--builder-primary);
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .preview-container {
            flex: 1;
            padding: 40px;
            display: flex;
            justify-content: center;
            overflow-y: auto;
            background: #e2e8f0;
            background-image: radial-gradient(#cbd5e1 1px, transparent 1px);
            background-size: 20px 20px;
        }

        .preview-frame {
            background: white;
            box-shadow: 0 20px 50px rgba(0,0,0,0.1);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            border-radius: 4px;
            overflow: hidden;
            height: fit-content;
            min-height: 100%;
        }

        .preview-desktop { width: 100%; max-width: 1280px; }
        .preview-tablet { width: 768px; }
        .preview-mobile { width: 375px; }

        .block-editable {
            position: relative;
            cursor: pointer;
            transition: outline 0.2s;
        }

        .block-editable:hover {
            outline: 2px solid var(--builder-primary);
            outline-offset: -2px;
        }

        .block-editable.active {
            outline: 3px solid var(--builder-primary);
            outline-offset: -2px;
        }

        .block-label {
            position: absolute;
            top: 0;
            right: 0;
            background: var(--builder-primary);
            color: white;
            font-size: 10px;
            padding: 2px 8px;
            z-index: 10;
            display: none;
            border-radius: 0 0 0 6px;
        }

        .block-editable:hover .block-label {
            display: block;
        }

        /* Sidebar field styles */
        .field-group {
            margin-bottom: 16px;
        }
        .field-label {
            display: block;
            font-size: 0.78rem;
            margin-bottom: 5px;
            font-weight: 600;
            color: #475569;
        }
        .field-input {
            width: 100%;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            padding: 10px 12px;
            font-size: 0.85rem;
            font-family: 'Cairo', sans-serif;
            transition: border-color 0.2s;
            background: white;
        }
        .field-input:focus {
            outline: none;
            border-color: var(--builder-primary);
            box-shadow: 0 0 0 3px rgba(0, 160, 176, 0.1);
        }
        .field-textarea {
            resize: vertical;
            min-height: 80px;
            line-height: 1.6;
        }
        .field-toggle {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 10px 14px;
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 10px;
            cursor: pointer;
            transition: all 0.2s;
        }
        .field-toggle:hover {
            background: #f1f5f9;
        }
        .field-color-wrap {
            display: flex;
            gap: 8px;
            align-items: center;
        }
        .field-color-picker {
            width: 36px;
            height: 36px;
            border: 2px solid #e2e8f0;
            padding: 2px;
            border-radius: 8px;
            cursor: pointer;
        }
        .field-select {
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 20 20'%3E%3Cpath stroke='%236b7280' stroke-linecap='round' stroke-linejoin='round' stroke-width='1.5' d='m6 8 4 4 4-4'/%3E%3C/svg%3E");
            background-position: left 10px center;
            background-repeat: no-repeat;
            background-size: 16px;
            padding-left: 32px;
        }
        .field-section-title {
            font-size: 0.7rem;
            font-weight: 800;
            color: var(--builder-primary);
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-top: 20px;
            margin-bottom: 10px;
            padding-bottom: 6px;
            border-bottom: 1px solid #e2e8f0;
        }
        .complex-data-badge {
            font-size: 0.72rem;
            color: #64748b;
            padding: 8px 12px;
            background: #f1f5f9;
            border-radius: 8px;
            display: flex;
            align-items: center;
            gap: 6px;
        }
        .complex-data-badge i { font-size: 0.8rem; color: #94a3b8; }

        /* RTL specific */
        [dir="rtl"] .builder-sidebar {
            border-left: none;
            border-right: 1px solid var(--builder-border);
        }

        .active-tab { background: white; color: var(--builder-primary); box-shadow: 0 2px 4px rgba(0,0,0,0.05); }
        .inactive-tab { background: transparent; color: #64748b; }
        .library-item {
            background: white; border: 1px solid #e2e8f0; border-radius: 12px; padding: 16px; margin-bottom: 12px;
            cursor: pointer; transition: all 0.2s; display: flex; align-items: center; gap: 15px;
        }
        .library-item:hover {
            border-color: var(--builder-primary); transform: translateY(-2px); box-shadow: 0 4px 12px rgba(0,160,176,0.1);
        }
        .library-icon {
            width: 40px; height: 40px; background: #f1f5f9; border-radius: 10px; display: flex; align-items: center; justify-content: center; color: #64748b;
        }
        .library-item:hover .library-icon { background: #e0f2f1; color: var(--builder-primary); }
        
        .control-card {
            background: #f8fafc; border: 1px solid #e2e8f0; border-radius: 12px; padding: 15px; margin-bottom: 20px;
        }
    </style>

    <!-- Sidebar: Real-time Controls -->
    <div class="builder-sidebar" x-data="{ activeTab: 'settings' }" x-show="sidebarOpen">
        <div class="builder-header">
            <h2 style="font-weight: 800; color: var(--builder-primary); margin: 0; font-size: 1.1rem; display: flex; align-items: center; gap: 10px;">
                <div style="width: 32px; height: 32px; background: linear-gradient(135deg, #00A0B0 0%, #2D9CDB 100%); border-radius: 8px; display: flex; align-items: center; justify-content: center; color: white;">
                    <i class="fas fa-layer-group" style="font-size: 0.9rem;"></i>
                </div>
                Prisma Editor
            </h2>
            <button @click="sidebarOpen = false" style="background:none; border:none; cursor:pointer; color: #94a3b8; font-size: 1.2rem;">
                <i class="fas fa-chevron-right"></i>
            </button>
        </div>

        {{-- ======= Global Edit Language Toggle ======= --}}
        <div style="padding: 12px 16px; background: {{ $previewLocale === 'ar' ? '#fffbeb' : '#eff6ff' }}; border-bottom: 2px solid {{ $previewLocale === 'ar' ? '#fbbf24' : '#3b82f6' }}; transition: all 0.3s;">
            <div style="font-size: 0.7rem; font-weight: 700; color: #64748b; margin-bottom: 8px; text-transform: uppercase; letter-spacing: 0.05em;">
                <i class="fas fa-language" style="margin-left: 5px;"></i>
                لغة التعديل / Edit Language
            </div>
            <div style="display: flex; gap: 0; border-radius: 10px; overflow: hidden; border: 1.5px solid {{ $previewLocale === 'ar' ? '#fbbf24' : '#3b82f6' }};">
                <button wire:click="setPreviewLocale('ar')"
                        style="flex: 1; padding: 9px 0; border: none; cursor: pointer; font-weight: 800; font-size: 0.88rem; font-family: 'Cairo', sans-serif; transition: all 0.2s;
                               background: {{ $previewLocale === 'ar' ? '#f59e0b' : 'white' }};
                               color: {{ $previewLocale === 'ar' ? 'white' : '#94a3b8' }};">
                    <i class="fas fa-check-circle" style="margin-left: 5px; {{ $previewLocale !== 'ar' ? 'display:none' : '' }}"></i>
                    🇸🇦 العربية
                </button>
                <button wire:click="setPreviewLocale('en')"
                        style="flex: 1; padding: 9px 0; border: none; border-right: 1.5px solid {{ $previewLocale === 'ar' ? '#fbbf24' : '#3b82f6' }}; cursor: pointer; font-weight: 800; font-size: 0.88rem; font-family: 'Cairo', sans-serif; transition: all 0.2s;
                               background: {{ $previewLocale === 'en' ? '#3b82f6' : 'white' }};
                               color: {{ $previewLocale === 'en' ? 'white' : '#94a3b8' }};">
                    <i class="fas fa-check-circle" style="margin-left: 5px; {{ $previewLocale !== 'en' ? 'display:none' : '' }}"></i>
                    🇬🇧 English
                </button>
            </div>
        </div>

        {{-- Sidebar Tabs --}}
        <div style="display: flex; background: #f8fafc; border-bottom: 1px solid #e2e8f0; padding: 4px;">
            <button @click="activeTab = 'settings'" :class="activeTab === 'settings' ? 'active-tab' : 'inactive-tab'" style="flex: 1; padding: 8px; border: none; cursor: pointer; border-radius: 6px; font-weight: 700; font-size: 0.8rem;">
                <i class="fas fa-sliders-h" style="margin-left: 5px;"></i>التعديل
            </button>
            <button @click="activeTab = 'library'" :class="activeTab === 'library' ? 'active-tab' : 'inactive-tab'" style="flex: 1; padding: 8px; border: none; cursor: pointer; border-radius: 6px; font-weight: 700; font-size: 0.8rem;">
                <i class="fas fa-plus-circle" style="margin-left: 5px;"></i>إضافة قسم
            </button>
        </div>

        <div style="flex: 1; overflow-y: auto; padding: 20px;">
            <div x-show="activeTab === 'library'">
                <h3 style="font-size: 0.9rem; font-weight: 800; margin-bottom: 20px; color: #1e293b;">مكتبة الأقسام الذكية</h3>
                @foreach($this->getAvailableBlocks() as $libBlock)
                    <div class="library-item" wire:click="addBlock('{{ $libBlock['type'] }}')">
                        <div class="library-icon"><x-filament::icon :icon="$libBlock['icon']" class="w-5 h-5" /></div>
                        <div>
                            <div style="font-weight: 700; font-size: 0.85rem; color: #1e293b;">{{ $libBlock['label'] }}</div>
                            <div style="font-size: 0.75rem; color: #64748b;">قسم احترافي جاهز للتخصيص</div>
                        </div>
                    </div>
                @endforeach
            </div>

            <div x-show="activeTab === 'settings'">
                @if($activeBlockIndex === null)
                    <!-- General Settings -->
                    <div class="control-card">
                        <h3 style="font-size: 0.85rem; font-weight: 800; margin-bottom: 15px; color: var(--builder-primary);">نظام التصميم</h3>
                        <div class="field-group">
                            <label class="field-label">اللون الأساسي</label>
                            <div class="field-color-wrap">
                                <input type="color" wire:model.live="settings.primary_color" class="field-color-picker">
                                <input type="text" wire:model.live="settings.primary_color" class="field-input" style="flex: 1; font-family: monospace; font-size: 0.8rem;">
                            </div>
                        </div>
                    </div>

                    <!-- Block layer list -->
                    <div class="control-card">
                        <h3 style="font-size: 0.85rem; font-weight: 800; margin-bottom: 15px; color: var(--builder-primary);">
                            <i class="fas fa-layer-group" style="margin-left: 6px;"></i>الأقسام ({{ count($content) }})
                        </h3>
                        @foreach($content as $idx => $blk)
                        <div 
                            wire:click="selectBlock({{ $idx }})" 
                            style="display: flex; align-items: center; gap: 10px; padding: 10px 12px; background: white; border: 1px solid #e2e8f0; border-radius: 8px; margin-bottom: 8px; cursor: pointer; transition: all 0.2s;"
                            onmouseover="this.style.borderColor='#00A0B0'"
                            onmouseout="this.style.borderColor='#e2e8f0'"
                        >
                            <span style="font-size: 0.7rem; color: #94a3b8; font-weight: 700; width: 20px;">{{ $idx + 1 }}</span>
                            <span style="font-weight: 600; font-size: 0.82rem; color: #1e293b; flex: 1;">{{ $this->getBlockLabel($blk['type']) }}</span>
                            <i class="fas fa-chevron-left" style="font-size: 0.7rem; color: #94a3b8;"></i>
                        </div>
                        @endforeach

                        @if(count($content) === 0)
                        <div style="text-align: center; padding: 20px; color: #94a3b8; font-size: 0.82rem;">
                            <i class="fas fa-inbox" style="font-size: 2rem; margin-bottom: 10px; display: block; opacity: 0.5;"></i>
                            لا توجد أقسام بعد. أضف قسمًا من المكتبة.
                        </div>
                        @endif
                    </div>
                @else
                    @php $block = $content[$activeBlockIndex] ?? null; @endphp
                    @if($block)
                    <!-- Block Management -->
                    <div style="display: flex; gap: 8px; margin-bottom: 16px;">
                        <button wire:click="selectBlock(null)" style="flex: 2; padding: 8px; background: white; border: 1px solid #e2e8f0; border-radius: 8px; cursor: pointer; font-weight: 700; font-size: 0.78rem; color: var(--builder-primary); display: flex; align-items: center; justify-content: center; gap: 5px;">
                            <i class="fas fa-arrow-right"></i> الرجوع
                        </button>
                        <button wire:click="moveBlock({{ $activeBlockIndex }}, 'up')" class="device-btn" style="flex: 1; background: white; border: 1px solid #e2e8f0;" title="تحريك لأعلى"><i class="fas fa-arrow-up"></i></button>
                        <button wire:click="moveBlock({{ $activeBlockIndex }}, 'down')" class="device-btn" style="flex: 1; background: white; border: 1px solid #e2e8f0;" title="تحريك لأسفل"><i class="fas fa-arrow-down"></i></button>
                        <button wire:click="removeBlock({{ $activeBlockIndex }})" class="device-btn" style="flex: 1; background: #fee2e2; border: 1px solid #fecaca; color: #dc2626;" title="حذف"><i class="fas fa-trash-alt"></i></button>
                    </div>

                    {{-- Block header --}}
                    <div class="control-card" style="margin-bottom: 16px;">
                        <div style="display: flex; align-items: center; gap: 10px; flex-wrap: wrap;">
                            <span style="background: linear-gradient(135deg, #00A0B0 0%, #2D9CDB 100%); color: white; padding: 4px 12px; border-radius: 50px; font-size: 0.7rem; font-weight: 700;">{{ $this->getBlockLabel($block['type']) }}</span>
                            <span style="font-size: 0.72rem; color: #94a3b8;">القسم {{ $activeBlockIndex + 1 }} من {{ count($content) }}</span>
                            {{-- Language mode badge --}}
                            <span style="margin-right: auto; background: {{ $previewLocale === 'ar' ? '#fef3c7' : '#dbeafe' }}; color: {{ $previewLocale === 'ar' ? '#92400e' : '#1e40af' }}; padding: 3px 10px; border-radius: 50px; font-size: 0.7rem; font-weight: 700; display: flex; align-items: center; gap: 4px;">
                                <i class="fas fa-language"></i>
                                {{ $previewLocale === 'ar' ? 'تعديل: عربي' : 'Editing: English' }}
                            </span>
                        </div>
                    </div>

                    {{-- Block Specific Settings (locale-aware) --}}
                    @foreach($block['data'] as $key => $value)
                        @php
                            $isArField = str_ends_with($key, '_ar');
                            $isEnField = str_ends_with($key, '_en');

                            // Skip the base title/subtitle/description (they are shadowed by _ar/_en variants)
                            $hasSuffixedVariant = isset($block['data'][$key . '_ar']) || isset($block['data'][$key . '_en']);

                            // Locale filtering:
                            //  - _ar fields: only show in Arabic editing mode
                            //  - _en fields: only show in English editing mode
                            //  - base fields that have _ar/_en variants: always skip (use the suffixed versions instead)
                            if ($isArField && $previewLocale !== 'ar') continue;
                            if ($isEnField && $previewLocale !== 'en') continue;
                            if (!$isArField && !$isEnField && $hasSuffixedVariant) continue;

                            $fieldType = $this->getFieldType($key, $value);
                            $fieldLabel = $this->getFieldLabel($key);
                            $wireModel = "content.{$activeBlockIndex}.data.{$key}";
                        @endphp

                        @if($fieldType === 'skip')
                            @continue
                        @endif

                        <div class="field-group">
                            @if($fieldType === 'toggle')
                                <label class="field-toggle">
                                    <span style="font-size: 0.82rem; font-weight: 600; color: #475569;">{{ $fieldLabel }}</span>
                                    <div style="position: relative; width: 44px; height: 24px;">
                                        <input type="checkbox" wire:model.live="{{ $wireModel }}" style="opacity: 0; width: 0; height: 0; position: absolute;">
                                        <div style="width: 44px; height: 24px; background: {{ $value ? 'var(--builder-primary)' : '#cbd5e1' }}; border-radius: 12px; transition: background 0.2s; cursor: pointer; position: relative;"
                                             wire:click="$set('{{ $wireModel }}', {{ $value ? 'false' : 'true' }})">
                                            <div style="width: 20px; height: 20px; background: white; border-radius: 50%; position: absolute; top: 2px; {{ $value ? 'left: 2px;' : 'right: 2px;' }} transition: all 0.2s; box-shadow: 0 1px 3px rgba(0,0,0,0.2);"></div>
                                        </div>
                                    </div>
                                </label>

                            @elseif($fieldType === 'color')
                                <label class="field-label">{{ $fieldLabel }}</label>
                                <div class="field-color-wrap">
                                    <input type="color" wire:model.live="{{ $wireModel }}" class="field-color-picker">
                                    <input type="text" wire:model.live="{{ $wireModel }}" class="field-input" style="flex: 1; font-family: monospace; font-size: 0.8rem;">
                                </div>

                            @elseif($fieldType === 'select')
                                <label class="field-label">{{ $fieldLabel }}</label>
                                <select wire:model.live="{{ $wireModel }}" class="field-input field-select">
                                    @foreach($this->getSelectOptions($key) as $optVal => $optLabel)
                                        <option value="{{ $optVal }}">{{ $optLabel }}</option>
                                    @endforeach
                                </select>

                            @elseif($fieldType === 'number')
                                <label class="field-label">{{ $fieldLabel }}</label>
                                <input type="number" wire:model.live="{{ $wireModel }}" class="field-input" min="0" max="100">

                            @elseif($fieldType === 'url')
                                <label class="field-label">{{ $fieldLabel }}</label>
                                <input type="url" wire:model.live="{{ $wireModel }}" class="field-input" dir="ltr" placeholder="https://...">

                            @elseif($fieldType === 'textarea')
                                <label class="field-label">{{ $fieldLabel }}</label>
                                <textarea wire:model.live="{{ $wireModel }}" class="field-input field-textarea" rows="3"></textarea>

                            @elseif($fieldType === 'complex')
                                <label class="field-label">{{ $fieldLabel }}</label>
                                @if(is_array($value) && count($value) > 0)
                                    <div class="complex-data-badge">
                                        <i class="fas fa-list"></i>
                                        {{ count($value) }} عنصر
                                        <span style="font-size: 0.65rem; color: #94a3b8; margin-right: auto;">(تحرير من لوحة الإدارة)</span>
                                    </div>
                                @else
                                    <div class="complex-data-badge">
                                        <i class="fas fa-info-circle"></i>
                                        لا توجد بيانات
                                    </div>
                                @endif

                            @else
                                <label class="field-label">{{ $fieldLabel }}</label>
                                <input type="text" wire:model.live="{{ $wireModel }}" class="field-input"
                                       dir="{{ ($isArField || (!$isEnField && $previewLocale === 'ar')) ? 'rtl' : 'ltr' }}">
                            @endif
                        </div>
                    @endforeach
                    @endif
                @endif
            </div>
        </div>

        <div style="padding: 20px; border-top: 1px solid var(--builder-border);">
            <button wire:click="save" style="width: 100%; background: linear-gradient(135deg, #00A0B0 0%, #2D9CDB 100%); color: white; border: none; padding: 12px; border-radius: 12px; font-weight: 700; cursor: pointer; box-shadow: 0 4px 15px rgba(0, 160, 176, 0.3); transition: transform 0.2s; font-family: 'Cairo', sans-serif; font-size: 0.95rem;"
                onmouseover="this.style.transform='translateY(-2px)'"
                onmouseout="this.style.transform='translateY(0)'"
            >
                <i class="fas fa-save" style="margin-left: 8px;"></i>
                حفظ التغييرات
            </button>
        </div>
    </div>

    <!-- Main Builder Canvas -->
    <div class="builder-canvas-wrapper">
        <div class="builder-toolbar">
            <div style="position: absolute; right: 20px; font-weight: 700; color: #1e293b; display: flex; align-items: center; gap: 10px;">
                <img src="{{ asset('logo.png') }}" style="height: 24px; opacity: 0.8;" onerror="this.style.display='none'">
                <span>Prisma Builder</span>
            </div>

            {{-- Device Toggle --}}
            <div class="device-toggle">
                <button @click="$wire.setDevice('desktop')" :class="$wire.activeDevice === 'desktop' ? 'active' : ''" class="device-btn"><i class="fas fa-desktop"></i></button>
                <button @click="$wire.setDevice('tablet')"  :class="$wire.activeDevice === 'tablet'  ? 'active' : ''" class="device-btn"><i class="fas fa-tablet-alt"></i></button>
                <button @click="$wire.setDevice('mobile')"  :class="$wire.activeDevice === 'mobile'  ? 'active' : ''" class="device-btn"><i class="fas fa-mobile-alt"></i></button>
            </div>

            {{-- Global Language Toggle --}}
            <div class="device-toggle" style="margin-right: 12px;" title="معاينة اللغة">
                <button wire:click="setPreviewLocale('ar')"
                        class="device-btn {{ $activeLocaleClass ?? '' }}"
                        style="{{ $previewLocale === 'ar' ? 'background:white;color:var(--builder-primary);box-shadow:0 2px 4px rgba(0,0,0,0.05);' : '' }}"
                >
                    <span style="font-family:'Cairo',sans-serif;font-weight:700;font-size:0.8rem;">ع</span>
                    <span style="font-size:0.7rem;margin-right:2px;">AR</span>
                </button>
                <button wire:click="setPreviewLocale('en')"
                        class="device-btn"
                        style="{{ $previewLocale === 'en' ? 'background:white;color:var(--builder-primary);box-shadow:0 2px 4px rgba(0,0,0,0.05);' : '' }}"
                >
                    <span style="font-size:0.75rem;font-weight:700;">EN</span>
                </button>
            </div>

            <div style="position: absolute; left: 20px; display: flex; gap: 12px;">
                <button @click="sidebarOpen = !sidebarOpen" class="device-btn" style="background: white; border: 1px solid #e2e8f0;"><i class="fas fa-columns"></i></button>
            </div>
        </div>

        <div class="preview-container">
            <div class="preview-frame {{ 'preview-' . $activeDevice }}">
                <!-- The actual Page Rendering -->
                <div class="rendered-page" style="pointer-events: auto;">
                    @foreach($content as $index => $block)
                        <div class="block-editable {{ $activeBlockIndex === $index ? 'active' : '' }}" 
                             wire:click="selectBlock({{ $index }})"
                             wire:key="block-{{ $index }}-{{ $block['type'] }}"
                             @click.stop
                        >
                            <span class="block-label">{{ $this->getBlockLabel($block['type']) }}</span>
                            @php
                                $componentName = 'blocks.' . str_replace('_', '-', $block['type']);
                            @endphp
                            
                            <x-dynamic-component 
                                :component="$componentName" 
                                :data="$block['data']" 
                            />
                        </div>
                    @endforeach

                    @if(count($content) === 0)
                    <div style="padding: 120px 40px; text-align: center; color: #94a3b8;">
                        <i class="fas fa-plus-circle" style="font-size: 4rem; margin-bottom: 20px; display: block; opacity: 0.3;"></i>
                        <p style="font-size: 1.1rem; font-weight: 700; margin-bottom: 8px;">ابدأ بإضافة أقسام</p>
                        <p style="font-size: 0.85rem;">استخدم مكتبة الأقسام من الشريط الجانبي</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Toast Notification -->
    <div x-data="{ show: false, message: '', type: 'success' }"
         x-on:notify.window="show = true; message = $event.detail.message; type = $event.detail.type; setTimeout(() => show = false, 3000)"
         x-show="show"
         x-transition
         style="position: fixed; bottom: 30px; left: 30px; z-index: 1000; padding: 16px 24px; border-radius: 12px; background: white; color: #1e293b; box-shadow: 0 10px 30px rgba(0,0,0,0.1); border-right: 4px solid var(--builder-primary); display: flex; align-items: center; gap: 12px;"
    >
        <i class="fas fa-check-circle" style="color: #10b981;"></i>
        <span x-text="message" style="font-weight: 700;"></span>
    </div>
</div>
