@php
$title = $package['title'] ?? 'تفاصيل الباقة';
$desc = $package['description'] ?? '';
$price = $package['price'] ?? 0;
$priceNonSaudi = $package['price_non_saudi'] ?? ($price * 1.15);
$originalPrice = $package['original_price'] ?? null;
$discountPercent = $package['discount_percent'] ?? null;
$imageUrl = $package['image_url'] ?? 'https://images.unsplash.com/photo-1579684385127-1ef15d508118?ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80';
$groups = $package['groups'] ?? [];
$fasting = $package['fasting'] ?? false;
@endphp

{{-- Modal Overlay --}}
<div 
    x-data="{ open: @entangle('isOpen') }"
    x-show="open"
    x-transition:enter="transition ease-out duration-300"
    x-transition:enter-start="opacity-0"
    x-transition:enter-end="opacity-100"
    x-transition:leave="transition ease-in duration-200"
    x-transition:leave-start="opacity-100"
    x-transition:leave-end="opacity-0"
    @keydown.escape.window="$wire.closeModal()"
    class="fixed inset-0 z-50 overflow-y-auto"
    style="display: none;"
    aria-labelledby="modal-title"
    role="dialog"
    aria-modal="true"
>
    {{-- Background Overlay --}}
    <div class="fixed inset-0 bg-black bg-opacity-70 backdrop-blur-sm transition-opacity" 
         @click="$wire.closeModal()"></div>

    {{-- Modal Content --}}
    <div class="flex min-h-screen items-center justify-center p-4">
        <div 
            x-show="open"
            x-transition:enter="transition ease-out duration-300"
            x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
            x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave="transition ease-in duration-200"
            x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
            x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
            class="relative w-full max-w-4xl bg-white rounded-2xl shadow-2xl overflow-hidden"
            @click.stop
        >
            {{-- Modal Header --}}
            <div class="sticky top-0 z-10 bg-white border-b border-gray-200 px-6 py-4 flex items-center justify-between">
                <h3 class="text-xl font-bold text-[#1A365D]" id="modal-title">تفاصيل الباقة</h3>
                <button 
                    type="button"
                    @click="$wire.closeModal()"
                    class="w-10 h-10 flex items-center justify-center rounded-full bg-gray-100 hover:bg-gray-200 text-gray-600 hover:text-[#00A0B0] transition-colors"
                >
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>

            {{-- Modal Body --}}
            <div class="max-h-[calc(90vh-80px)] overflow-y-auto">
                {{-- Hero Image with Price Overlay --}}
                <div class="relative">
                    <img src="{{ $imageUrl }}" alt="{{ $title }}" class="w-full h-64 object-cover">
                    <div class="absolute bottom-0 right-0 bg-gradient-to-r from-[#1A365D] to-[#2D3748] text-white px-8 py-6 rounded-tl-3xl">
                        @if($discountPercent)
                            <div class="text-sm font-semibold mb-1 opacity-90">خصم {{ $discountPercent }}%</div>
                        @else
                            <div class="text-sm font-semibold mb-1 opacity-90">عرض مميز</div>
                        @endif
                        <div class="text-4xl font-black font-['Cairo']">{{ $price }}</div>
                        <div class="text-sm opacity-90 mt-1">ريال سعودي</div>
                    </div>
                </div>

                {{-- Package Details --}}
                <div class="p-6">
                    <h2 class="text-2xl font-black text-[#1A365D] mb-3">{{ $title }}</h2>
                    <p class="text-gray-600 leading-relaxed mb-6">{{ $desc }}</p>

                    {{-- Features --}}
                    <h4 class="text-lg font-bold text-[#1A365D] mb-4 flex items-center gap-2">
                        <i class="fas fa-list-check text-[#00A0B0]"></i>
                        ما تشمله الباقة
                    </h4>
                    
                    <div class="space-y-3 mb-6">
                        @foreach($groups as $group)
                            <div class="bg-gray-50 border border-gray-200 rounded-xl p-4">
                                <h5 class="font-bold text-[#1A365D] mb-3 flex items-center gap-2">
                                    <i class="fas fa-vial text-[#00A0B0]"></i>
                                    {{ $group['title'] ?? '' }}
                                </h5>
                                <ul class="space-y-2">
                                    @foreach($group['tests'] ?? [] as $test)
                                        <li class="flex items-center gap-2 text-gray-700">
                                            <i class="fas fa-check-circle text-green-500 text-sm"></i>
                                            <span>{{ $test }}</span>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        @endforeach
                    </div>

                    {{-- Price Variants --}}
                    <div class="bg-gray-50 border border-gray-200 rounded-xl p-5 mb-6">
                        <div class="flex justify-between items-center py-3 border-b border-gray-200">
                            <span class="text-gray-600 font-semibold">السعر للمواطن / المقيم (شامل الضريبة)</span>
                            <span class="text-xl font-black text-[#1A365D] font-['Cairo']">{{ $price }} ريال</span>
                        </div>
                        <div class="flex justify-between items-center py-3">
                            <span class="text-gray-600 font-semibold">السعر لغير السعودي (شامل الضريبة)</span>
                            <span class="text-xl font-black text-[#1A365D] font-['Cairo']">{{ round($priceNonSaudi) }} ريال</span>
                        </div>
                    </div>

                    {{-- Booking Form --}}
                    <div class="bg-white border-2 border-[#00A0B0] rounded-xl p-6">
                        <h4 class="text-lg font-bold text-[#1A365D] mb-4 flex items-center gap-2">
                            <i class="fas fa-calendar-check text-[#00A0B0]"></i>
                            احجز الآن
                        </h4>

                        <form wire:submit.prevent="submitBooking">
                            <div class="mb-4">
                                <label class="block text-sm font-bold text-[#1A365D] mb-2">الاسم (مطلوب)</label>
                                <input 
                                    type="text" 
                                    wire:model="name"
                                    placeholder="أدخل اسمك"
                                    class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:border-[#00A0B0] focus:outline-none transition-colors"
                                >
                                @error('name') <span class="text-red-500 text-sm mt-1">{{ $message }}</span> @enderror
                            </div>

                            <div class="mb-4">
                                <label class="block text-sm font-bold text-[#1A365D] mb-2">رقم الجوال (مطلوب)</label>
                                <input 
                                    type="tel" 
                                    wire:model="phone"
                                    placeholder="05xxxxxxxx"
                                    class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:border-[#00A0B0] focus:outline-none transition-colors"
                                >
                                @error('phone') <span class="text-red-500 text-sm mt-1">{{ $message }}</span> @enderror
                            </div>

                            <div class="mb-6">
                                <label class="block text-sm font-bold text-[#1A365D] mb-2">ملاحظة (اختياري)</label>
                                <textarea 
                                    wire:model="note"
                                    placeholder="أي ملاحظات إضافية..."
                                    rows="3"
                                    class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:border-[#00A0B0] focus:outline-none transition-colors resize-none"
                                ></textarea>
                            </div>

                            <div class="space-y-3">
                                <button 
                                    type="submit"
                                    class="w-full py-4 bg-[#1A365D] hover:bg-[#2D3748] text-white font-bold rounded-xl transition-colors flex items-center justify-center gap-2"
                                >
                                    <i class="fas fa-paper-plane"></i>
                                    احجز الآن
                                </button>

                                <a 
                                    href="{{ $this->getWhatsAppUrl() }}"
                                    target="_blank"
                                    class="w-full py-4 bg-[#25D366] hover:bg-[#1da851] text-white font-bold rounded-xl transition-colors flex items-center justify-center gap-2"
                                >
                                    <i class="fab fa-whatsapp text-xl"></i>
                                    احجز عبر واتساب
                                </a>

                                <button 
                                    type="button"
                                    onclick="alert('سيتم تحويلك لصفحة الدفع (تمارا / تابي / بطاقة ائتمان)')"
                                    class="w-full py-4 bg-white border-2 border-[#1A365D] text-[#1A365D] hover:bg-[#1A365D] hover:text-white font-bold rounded-xl transition-colors flex items-center justify-center gap-2"
                                >
                                    <i class="fas fa-credit-card"></i>
                                    احجز بالدفع (تمارا / تابي / بطاقة)
                                </button>
                            </div>
                        </form>
                    </div>

                    {{-- Accordions --}}
                    <div class="mt-6 space-y-3">
                        <div class="border border-gray-200 rounded-xl overflow-hidden">
                            <button 
                                type="button"
                                class="w-full px-6 py-4 bg-gray-50 hover:bg-gray-100 flex items-center justify-between font-bold text-[#1A365D] transition-colors"
                                onclick="this.nextElementSibling.classList.toggle('hidden')"
                            >
                                <span>آلية العمل</span>
                                <div class="w-7 h-7 bg-[#00A0B0] text-white rounded-full flex items-center justify-center">
                                    <i class="fas fa-chevron-down text-xs"></i>
                                </div>
                            </button>
                            <div class="hidden px-6 py-4 border-t border-gray-200 text-gray-600 leading-relaxed">
                                احجز عبر الموقع أو واتساب، نحدد موعد السحب المنزلي أو زيارة الفرع، يتم سحب العينة وإرسال النتائج خلال 24 ساعة.
                            </div>
                        </div>

                        <div class="border border-gray-200 rounded-xl overflow-hidden">
                            <button 
                                type="button"
                                class="w-full px-6 py-4 bg-gray-50 hover:bg-gray-100 flex items-center justify-between font-bold text-[#1A365D] transition-colors"
                                onclick="this.nextElementSibling.classList.toggle('hidden')"
                            >
                                <span>تعليمات قبل الخدمة</span>
                                <div class="w-7 h-7 bg-[#00A0B0] text-white rounded-full flex items-center justify-center">
                                    <i class="fas fa-chevron-down text-xs"></i>
                                </div>
                            </button>
                            <div class="hidden px-6 py-4 border-t border-gray-200 text-gray-600 leading-relaxed">
                                @if($fasting)
                                    يتطلب صيام 10-12 ساعة. يسمح بشرب الماء فقط. تظهر النتائج خلال 24 ساعة عبر رسالة نصية.
                                @else
                                    لا يتطلب صياماً مسبقاً. تظهر النتائج خلال 24 ساعة عبر رسالة نصية.
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@if (session()->has('booking_success'))
    <div 
        x-data="{ show: true }"
        x-show="show"
        x-init="setTimeout(() => show = false, 5000)"
        class="fixed top-4 right-4 z-[60] bg-green-500 text-white px-6 py-4 rounded-lg shadow-lg"
    >
        <i class="fas fa-check-circle mr-2"></i>
        {{ session('booking_success') }}
    </div>
@endif
