<x-layouts.app>
    @section('title', $page->meta_title ?? $page->title)
    @section('description', $page->meta_description)
    @section('keywords', is_array($page->meta_keywords) ? implode(', ', $page->meta_keywords) : $page->meta_keywords)

    @php
        $pageData = [
            'title' => $page->title,
            'content_type' => gettype($page->content),
            'content' => collect($page->content)->toArray(),
            'custom_html' => $page->custom_html,
        ];
        file_put_contents('/tmp/preview_debug.log', "--- BLADE RENDER ---\n" . json_encode($pageData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n", FILE_APPEND);
    @endphp

    {{-- Full HTML page (when custom_html is set) --}}
    @if(!empty($page->custom_html))
        <div class="page-custom-html">{!! $page->custom_html !!}</div>
    {{-- Render Content Blocks --}}
    @elseif(!empty($page->content))
        @foreach($page->content as $block)
            @php
                $type = $block['type'] ?? '';
                $data = $block['data'] ?? null;
            @endphp

            @if(!empty($type) && is_array($data))
                @switch($type)
                @case('hero_slider')
                    <x-blocks.hero-slider :slides="$data['slides'] ?? []" />
                    @break

                @case('package_grid')
                    <x-blocks.package-grid 
                        :title="block_trans($data, 'title', 'Our Packages')"
                        :description="block_trans($data, 'description', '')"
                        :packages-source="$data['packages_source'] ?? 'featured'"
                        :limit="$data['limit'] ?? 6"
                        :columns="$data['columns'] ?? '3'"
                        :show-view-all="$data['show_view_all'] ?? true"
                        :view-all-text="$data['view_all_text'] ?? 'View All Packages'"
                        :view-all-url="$data['view_all_url'] ?? '/packages'" />
                    @break

                @case('features')
                    <x-blocks.features 
                        :title="block_trans($data, 'title', 'Why Choose Us')"
                        :description="block_trans($data, 'description', '')"
                        :layout="$data['layout'] ?? 'grid'"
                        :icon-style="$data['icon_style'] ?? 'outline'"
                        :icon-color="$data['icon_color'] ?? '#0ea5e9'"
                        :features="$data['features'] ?? []" />
                    @break

                @case('cta')
                    <x-blocks.cta 
                        :title="block_trans($data, 'title', '')"
                        :description="block_trans($data, 'description', '')"
                        :background-image="$data['background_image'] ?? ''"
                        :background-color="$data['background_color'] ?? '#0ea5e9'"
                        :text-color="$data['text_color'] ?? '#ffffff'"
                        :button-text="$data['button_text'] ?? ''"
                        :button-url="$data['button_url'] ?? ''"
                        :secondary-button-text="$data['secondary_button_text'] ?? ''"
                        :secondary-button-url="$data['secondary_button_url'] ?? ''"
                        :alignment="$data['alignment'] ?? 'center'" />
                    @break

                @case('html')
                    <x-blocks.html 
                        :html-content="$data['html_content'] ?? ''"
                        :full-width="$data['full_width'] ?? false"
                        :add-container="$data['add_container'] ?? true" />
                    @break

                @case('prisma_hero')
                    <x-blocks.prisma-hero :data="$data" />
                    @break

                @case('prisma_hero_grid')
                    <x-blocks.prisma-hero-grid :data="$data" />
                    @break

                @case('prisma_categories')
                    <x-blocks.prisma-categories :data="$data" />
                    @break

                @case('prisma_packages')
                    <x-blocks.prisma-packages :data="$data" />
                    @break

                @case('prisma_about')
                    <x-blocks.prisma-about :data="$data" />
                    @break

                @case('prisma_services')
                    <x-blocks.prisma-services :data="$data" />
                    @break

                @case('prisma_faq')
                    <x-blocks.prisma-faq :data="$data" />
                    @break

                @case('prisma_cta')
                    <x-blocks.prisma-cta :data="$data" />
                    @break

                @case('prisma_separator')
                    <x-blocks.prisma-separator :data="$data" />
                    @break

                @case('custom_form')
                    <x-blocks.custom-form :data="$data" />
                    @break

            @endswitch
        @endif
        @endforeach
    @else
        {{-- Default content if no blocks and no custom_html --}}
        <section class="py-20 bg-gray-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center">
                    <h1 class="text-4xl md:text-5xl font-bold text-gray-900 mb-6">{{ $page->title }}</h1>
                    @if($page->description)
                        <p class="text-xl text-gray-600 max-w-3xl mx-auto">{{ $page->description }}</p>
                    @endif
                </div>
            </div>
        </section>
    @endif
</x-layouts.app>
