<?php
    $navbarTheme    = $siteSettings->navbar_theme    ?? 'dark';
    $navbarBg       = $siteSettings->navbar_bg_color ?? '#0a0a0a';

    // Dark navbar → use logo_dark  (logo designed to be visible on dark backgrounds)
    // Light navbar → use logo_light (logo designed to be visible on light backgrounds)
    $logoPath = $navbarTheme === 'dark'
        ? ($siteSettings->logo_dark  ?? $siteSettings->logo_light ?? null)
        : ($siteSettings->logo_light ?? $siteSettings->logo_dark  ?? null);

    $isDark          = $navbarTheme === 'dark';
    $textColor       = $isDark ? 'rgba(255,255,255,0.92)' : 'rgba(15,23,42,0.88)';
    $textHoverColor  = $isDark ? 'var(--pr-secondary)' : 'var(--pr-primary)';
    $borderColor     = $isDark ? 'rgba(255,255,255,0.28)' : 'rgba(0,0,0,0.18)';
    $mobileNavBg     = $isDark ? $navbarBg : '#ffffff';
    $iconColor       = $isDark ? 'white' : 'var(--pr-primary)';
    $bgStyle         = $isDark
        ? "background: {$navbarBg}; box-shadow: 0 2px 12px rgba(0,0,0,0.35);"
        : "background: #ffffff; box-shadow: 0 2px 12px rgba(0,0,0,0.08);";
?>

<header
    class="main-header"
    id="siteHeader"
    style="position: fixed; top: 0; left: 0; right: 0; height: var(--header-height); <?php echo e($bgStyle); ?> z-index: 100; display: flex; align-items: center; justify-content: center; padding: 0 20px;"
>
    <div class="header-container" style="width: 100%; max-width: 1300px; display: flex; justify-content: space-between; align-items: center;">

        
        <a href="<?php echo e(route('home')); ?>" class="logo" style="display: flex; align-items: center; gap: 10px; text-decoration: none;">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($logoPath): ?>
                <img src="<?php echo e(asset('storage/' . $logoPath)); ?>"
                     alt="<?php echo e($siteSettings->site_name); ?>"
                     style="height: 44px; width: auto; max-width: 220px; object-fit: contain; display: block;">
            <?php else: ?>
                <span style="color: <?php echo e($iconColor); ?>; font-size: 1.4rem; font-weight: 900; font-family: 'Cairo', sans-serif;">
                    <?php echo e($siteSettings->site_name); ?>

                </span>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </a>

        
        <nav class="nav-links" id="navLinks" style="display: flex; gap: 30px; align-items: center;">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $headerMenu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->children->isEmpty()): ?>
                    <a href="<?php echo e($item->url); ?>"
                       class="nav-link <?php echo e(request()->is(trim($item->url, '/')) ? 'active' : ''); ?>"
                       style="text-decoration: none; color: <?php echo e($textColor); ?>; font-weight: 600; font-family: 'Cairo', sans-serif; transition: var(--transition); position: relative; padding-bottom: 4px;">
                        <?php echo e($item->translated_title ?: __($item->title)); ?>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(request()->is(trim($item->url, '/'))): ?>
                            <span style="position: absolute; bottom: -24px; left: 0; right: 0; height: 3px; background: var(--pr-gradient); border-radius: 2px;"></span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </a>
                <?php else: ?>
                    <div class="relative group" x-data="{ open: false }">
                        <button @click="open = !open"
                                @mouseenter="open = true"
                                class="nav-link flex items-center gap-1"
                                style="text-decoration: none; color: <?php echo e($textColor); ?>; font-weight: 600; font-family: 'Cairo', sans-serif; transition: var(--transition); background: none; border: none; cursor: pointer;">
                            <?php echo e($item->translated_title ?: __($item->title)); ?>

                            <i class="fas fa-chevron-down text-xs"></i>
                        </button>
                        <div x-show="open"
                             @mouseleave="open = false"
                             x-transition
                             class="absolute top-full right-0 mt-2 w-48 bg-white rounded-xl shadow-xl py-2 z-50"
                             style="display: none;">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $item->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e($child->url); ?>"
                                   class="block px-4 py-2 text-gray-700 hover:text-primary hover:bg-gray-50 transition-colors">
                                    <?php echo e($child->translated_title ?: __($child->title)); ?>

                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($headerMenu->isEmpty()): ?>
                <a href="<?php echo e(route('home')); ?>" class="nav-link active"
                   style="text-decoration: none; color: <?php echo e($isDark ? 'var(--pr-secondary)' : 'var(--pr-primary)'); ?>; font-weight: 600; font-family: 'Cairo', sans-serif; position: relative;">
                    <?php echo e(__('home')); ?>

                    <span style="position: absolute; bottom: -24px; left: 0; right: 0; height: 3px; background: var(--pr-gradient); border-radius: 2px;"></span>
                </a>
                <a href="<?php echo e(route('packages.index')); ?>" class="nav-link"
                   style="text-decoration: none; color: <?php echo e($textColor); ?>; font-weight: 600; font-family: 'Cairo', sans-serif; transition: var(--transition);"><?php echo e(__('packages')); ?></a>
                <a href="#about" class="nav-link"
                   style="text-decoration: none; color: <?php echo e($textColor); ?>; font-weight: 600; font-family: 'Cairo', sans-serif; transition: var(--transition);"><?php echo e(__('about_us')); ?></a>
                <a href="#contact" class="nav-link"
                   style="text-decoration: none; color: <?php echo e($textColor); ?>; font-weight: 600; font-family: 'Cairo', sans-serif; transition: var(--transition);"><?php echo e(__('contact_us')); ?></a>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            
            <div class="language-switcher" style="display: flex; align-items: center; margin-right: 20px;">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(app()->getLocale() == 'ar'): ?>
                    <a href="<?php echo e(route('set-locale', 'en')); ?>"
                       style="text-decoration: none; color: <?php echo e($iconColor); ?>; font-weight: 700; font-family: 'Cairo', sans-serif; border: 1px solid <?php echo e($borderColor); ?>; padding: 5px 12px; border-radius: 20px; font-size: 0.9rem; transition: all 0.3s;">
                        English
                    </a>
                <?php else: ?>
                    <a href="<?php echo e(route('set-locale', 'ar')); ?>"
                       style="text-decoration: none; color: <?php echo e($iconColor); ?>; font-weight: 700; font-family: 'Cairo', sans-serif; border: 1px solid <?php echo e($borderColor); ?>; padding: 5px 12px; border-radius: 20px; font-size: 0.9rem; transition: all 0.3s;">
                        العربية
                    </a>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </nav>

        
        <div class="mobile-toggle lg:hidden"
             onclick="document.getElementById('navLinks').classList.toggle('active')"
             style="font-size: 1.5rem; cursor: pointer; color: <?php echo e($iconColor); ?>;">
            <i class="fas fa-bars"></i>
        </div>
    </div>
</header>

<style>
    .nav-link:hover {
        color: <?php echo e($textHoverColor); ?> !important;
    }

    @media (max-width: 768px) {
        .nav-links {
            display: none !important;
            position: absolute;
            top: var(--header-height);
            left: 0;
            right: 0;
            background: <?php echo e($mobileNavBg); ?>;
            flex-direction: column;
            padding: 20px;
            gap: 14px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.25);
        }
        .nav-links.active {
            display: flex !important;
        }
        .language-switcher {
            margin-right: 0 !important;
        }
    }
</style>
<?php /**PATH /Users/test/Documents/prisma1/resources/views/components/layouts/partials/header.blade.php ENDPATH**/ ?>