<?php if (isset($component)) { $__componentOriginal5863877a5171c196453bfa0bd807e410 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5863877a5171c196453bfa0bd807e410 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.layouts.app','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('layouts.app'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <?php $__env->startSection('title', __('packages_page_title') . ' - ' . ($siteSettings->site_name ?? 'مختبرات بريزما')); ?>
    <?php $__env->startSection('description', __('packages_page_desc')); ?>

    <style>
        :root {
            --pi-primary: #1A365D;
            --pi-secondary: #00A0B0;
            --pi-accent: #2D9CDB;
            --pi-gradient: linear-gradient(135deg, #1A365D 0%, #2D3748 60%, #00A0B0 100%);
            --pi-radius: 14px;
            --pi-shadow: 0 4px 20px rgba(0,0,0,0.08);
            --pi-shadow-card: 0 8px 32px rgba(0,0,0,0.06);
            --pi-transition: all 0.35s cubic-bezier(0.4, 0, 0.2, 1);
        }

        /* Hero */
        .pkg-idx-hero {
            background: var(--pi-gradient);
            padding: 56px 20px 48px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        .pkg-idx-hero::before {
            content: '';
            position: absolute;
            top: -40%;
            right: -10%;
            width: 500px;
            height: 500px;
            background: radial-gradient(circle, rgba(0,160,176,0.15) 0%, transparent 70%);
            border-radius: 50%;
        }
        .pkg-idx-hero h1 {
            font-family: 'Cairo', sans-serif;
            font-size: 2.5rem;
            font-weight: 800;
            color: white;
            margin-bottom: 12px;
            position: relative;
        }
        .pkg-idx-hero p {
            font-size: 1.15rem;
            color: rgba(255,255,255,0.88);
            max-width: 600px;
            margin: 0 auto 24px;
            line-height: 1.7;
        }
        .pkg-idx-hero nav {
            font-size: 0.9rem;
            color: rgba(255,255,255,0.7);
        }
        .pkg-idx-hero nav a {
            color: rgba(255,255,255,0.7);
            text-decoration: none;
            transition: color 0.2s;
        }
        .pkg-idx-hero nav a:hover { color: white; }

        /* Price Tier Tabs */
        .tier-tabs {
            display: flex;
            justify-content: center;
            gap: 8px;
            flex-wrap: wrap;
            padding: 24px 20px 0;
            max-width: 900px;
            margin: 0 auto;
        }
        .tier-tab {
            padding: 10px 22px;
            background: rgba(255,255,255,0.12);
            border: 1px solid rgba(255,255,255,0.2);
            border-radius: 50px;
            color: rgba(255,255,255,0.85);
            font-family: 'Cairo', sans-serif;
            font-size: 0.92rem;
            font-weight: 600;
            cursor: pointer;
            transition: var(--pi-transition);
            white-space: nowrap;
        }
        .tier-tab:hover {
            background: rgba(255,255,255,0.2);
            color: white;
        }
        .tier-tab.active {
            background: white;
            color: var(--pi-primary);
            border-color: white;
            box-shadow: 0 4px 16px rgba(0,0,0,0.15);
        }

        /* Packages Grid */
        .pkg-section {
            padding: 40px 20px 60px;
            background: #f5f7fa;
            min-height: 400px;
        }
        .pkg-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(340px, 1fr));
            gap: 24px;
            max-width: 1280px;
            margin: 0 auto;
        }
        @media (max-width: 768px) {
            .pkg-grid { grid-template-columns: 1fr; }
        }

        /* Package Card */
        .pkg-card {
            background: white;
            border-radius: var(--pi-radius);
            overflow: hidden;
            box-shadow: var(--pi-shadow-card);
            border: 1px solid #e8ecf1;
            transition: var(--pi-transition);
            display: flex;
            flex-direction: column;
        }
        .pkg-card:hover {
            transform: translateY(-6px);
            box-shadow: 0 16px 48px rgba(0,0,0,0.12);
            border-color: var(--pi-secondary);
        }

        .pkg-card-img {
            position: relative;
            height: 200px;
            overflow: hidden;
            background: linear-gradient(135deg, #e2e8f0, #f1f5f9);
        }
        .pkg-card-img img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s ease;
        }
        .pkg-card:hover .pkg-card-img img {
            transform: scale(1.08);
        }
        .pkg-card-img .fallback-icon {
            width: 100%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #e8f4f8 0%, #dbeafe 100%);
        }
        .pkg-card-img .fallback-icon i {
            font-size: 3.5rem;
            color: var(--pi-secondary);
            opacity: 0.35;
        }

        /* Badges */
        .pkg-badge-row {
            position: absolute;
            top: 12px;
            left: 12px;
            right: 12px;
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            z-index: 2;
        }
        .badge-discount {
            background: linear-gradient(135deg, #ef4444, #dc2626);
            color: white;
            padding: 5px 14px;
            border-radius: 50px;
            font-size: 0.82rem;
            font-weight: 700;
            font-family: 'Cairo', sans-serif;
            box-shadow: 0 2px 8px rgba(239,68,68,0.3);
        }
        .badge-featured {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            color: white;
            padding: 5px 12px;
            border-radius: 50px;
            font-size: 0.78rem;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 4px;
        }
        .badge-tests {
            position: absolute;
            bottom: 12px;
            right: 12px;
            background: rgba(26,54,93,0.88);
            backdrop-filter: blur(6px);
            color: white;
            padding: 6px 14px;
            border-radius: 50px;
            font-size: 0.8rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        /* Card Body */
        .pkg-card-body {
            padding: 20px 22px;
            flex: 1;
            display: flex;
            flex-direction: column;
        }
        .pkg-card-body h3 {
            font-family: 'Cairo', sans-serif;
            font-size: 1.15rem;
            font-weight: 700;
            color: var(--pi-primary);
            margin-bottom: 8px;
            line-height: 1.4;
            transition: color 0.2s;
        }
        .pkg-card:hover .pkg-card-body h3 {
            color: var(--pi-secondary);
        }
        .pkg-card-body .desc {
            font-size: 0.92rem;
            color: #64748B;
            line-height: 1.6;
            margin-bottom: 16px;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }
        .pkg-card-features {
            margin-bottom: 16px;
            flex: 1;
        }
        .pkg-card-features li {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 0.88rem;
            color: #475569;
            padding: 3px 0;
        }
        .pkg-card-features li i {
            color: #22c55e;
            font-size: 0.8rem;
            flex-shrink: 0;
        }
        .pkg-card-features .more {
            font-size: 0.8rem;
            color: #94a3b8;
            padding-right: 20px;
        }

        /* Card Footer */
        .pkg-card-footer {
            padding: 16px 22px 20px;
            border-top: 1px solid #f1f5f9;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 12px;
        }
        .pkg-price-wrap { display: flex; flex-direction: column; }
        .pkg-price-old {
            font-size: 0.82rem;
            color: #94a3b8;
            text-decoration: line-through;
            font-family: 'Cairo', sans-serif;
        }
        .pkg-price-current {
            font-size: 1.5rem;
            font-weight: 800;
            color: var(--pi-primary);
            font-family: 'Cairo', sans-serif;
            line-height: 1;
        }
        .pkg-price-current .sar {
            font-size: 0.75rem;
            font-weight: 600;
            color: #64748B;
            margin-right: 4px;
        }

        .pkg-card-actions {
            display: flex;
            gap: 8px;
            align-items: center;
        }
        .btn-details {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 10px 20px;
            background: var(--pi-primary);
            color: white;
            border-radius: 50px;
            font-size: 0.88rem;
            font-weight: 600;
            font-family: 'Cairo', sans-serif;
            text-decoration: none;
            transition: var(--pi-transition);
            white-space: nowrap;
        }
        .btn-details:hover {
            background: var(--pi-secondary);
            color: white;
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0,160,176,0.3);
        }
        .btn-book-sm {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 42px;
            height: 42px;
            background: #f0fdf4;
            color: #16a34a;
            border-radius: 50%;
            font-size: 1.1rem;
            text-decoration: none;
            transition: var(--pi-transition);
            border: 1px solid #bbf7d0;
        }
        .btn-book-sm:hover {
            background: #25D366;
            color: white;
            border-color: #25D366;
        }

        /* Empty State */
        .pkg-empty {
            text-align: center;
            padding: 60px 20px;
            max-width: 400px;
            margin: 0 auto;
        }
        .pkg-empty i { font-size: 4rem; color: #cbd5e1; margin-bottom: 20px; }
        .pkg-empty h3 { font-family: 'Cairo', sans-serif; color: var(--pi-primary); font-size: 1.3rem; margin-bottom: 8px; }
        .pkg-empty p { color: #94a3b8; font-size: 0.95rem; }
    </style>

    <div dir="rtl" style="font-family: 'Tajawal', 'Cairo', sans-serif;">
        
        <section class="pkg-idx-hero">
            <h1><?php echo e(__('hero_title')); ?></h1>
            <p><?php echo e(__('hero_subtitle')); ?></p>
            <nav>
                <a href="<?php echo e(route('home')); ?>"><?php echo e(__('home')); ?></a>
                <span style="margin: 0 8px;">/</span>
                <span style="color: white;"><?php echo e(__('packages')); ?></span>
            </nav>

            
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($priceTiers->count() > 1): ?>
                <div class="tier-tabs">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $priceTiers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $tier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button class="tier-tab <?php echo e($index === 0 ? 'active' : ''); ?>"
                                data-tier="<?php echo e($index); ?>"
                                onclick="filterTier(<?php echo e($index); ?>)">
                            <?php echo e(app()->getLocale() == 'en' ? ($tier['label_en'] ?? $tier['label']) : $tier['label']); ?>

                        </button>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </section>

        
        <section class="pkg-section">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($packages->count() > 0): ?>
                <div class="pkg-grid" id="packages-grid">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="pkg-card" data-price="<?php echo e($package->final_price); ?>">
                            
                            <div class="pkg-card-img">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->image): ?>
                                    <img src="<?php echo e(asset('storage/' . $package->image)); ?>" alt="<?php echo e($package->translated_name); ?>" loading="lazy">
                                <?php else: ?>
                                    <div class="fallback-icon">
                                        <i class="fas fa-microscope"></i>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                
                                <div class="pkg-badge-row">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->discount_percentage > 0): ?>
                                        <span class="badge-discount"><?php echo e(__('discount_badge')); ?> <?php echo e($package->discount_percentage); ?>%</span>
                                    <?php else: ?>
                                        <span></span>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->is_featured): ?>
                                        <span class="badge-featured"><i class="fas fa-star"></i> <?php echo e(__('featured_badge')); ?></span>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>

                                
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->tests_count > 0): ?>
                                    <span class="badge-tests"><i class="fas fa-vial"></i> <?php echo e($package->tests_count); ?> <?php echo e($package->tests_count == 1 ? __('test_count_single') : __('test_count_suffix')); ?></span>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            
                            <div class="pkg-card-body">
                                <h3><?php echo e($package->translated_name); ?></h3>
                                <p class="desc"><?php echo e($package->translated_short_description ?? Str::limit(strip_tags($package->translated_description), 100)); ?></p>

                                
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->features && count($package->features) > 0): ?>
                                    <ul class="pkg-card-features" style="list-style: none; padding: 0; margin: 0;">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = array_slice($package->features, 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><i class="fas fa-check-circle"></i> <?php echo e(is_array($feature) ? ($feature['feature'] ?? '') : $feature); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($package->features) > 3): ?>
                                            <li class="more">+<?php echo e(count($package->features) - 3); ?> <?php echo e(__('more_features')); ?></li>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </ul>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            
                            <div class="pkg-card-footer">
                                <div class="pkg-price-wrap">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->sale_price): ?>
                                        <span class="pkg-price-old"><?php echo e(number_format($package->price)); ?> <?php echo e(__('currency_symbol')); ?></span>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <span class="pkg-price-current"><?php echo e(number_format($package->final_price)); ?> <span class="sar"><?php echo e(__('currency_sar')); ?></span></span>
                                </div>
                                <div class="pkg-card-actions">
                                    <a href="<?php echo e(route('package.show', $package->slug)); ?>" class="btn-details">
                                        <?php echo e(__('details_btn')); ?> <i class="fas fa-arrow-left"></i>
                                    </a>
                                    <a href="https://wa.me/966500000000?text=<?php echo e(urlencode(__('whatsapp_inquiry') . $package->translated_name)); ?>"
                                       target="_blank" rel="noopener"
                                       class="btn-book-sm" title="واتساب">
                                        <i class="fab fa-whatsapp"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            <?php else: ?>
                <div class="pkg-empty">
                    <i class="fas fa-box-open"></i>
                    <h3><?php echo e(__('no_packages')); ?></h3>
                    <p><?php echo e(__('no_packages_desc')); ?></p>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </section>
    </div>

    <script>
    // Price tier filtering
    const priceTiers = <?php echo json_encode($priceTiers, 15, 512) ?>;

    function filterTier(tierIndex) {
        // Update active tab
        document.querySelectorAll('.tier-tab').forEach((tab, i) => {
            tab.classList.toggle('active', i === tierIndex);
        });

        const tier = priceTiers[tierIndex];
        const cards = document.querySelectorAll('.pkg-card');

        cards.forEach(card => {
            const price = parseFloat(card.dataset.price);
            if (tierIndex === 0) {
                card.style.display = '';
            } else if (price >= tier.min && price <= tier.max) {
                card.style.display = '';
            } else {
                card.style.display = 'none';
            }
        });
    }
    </script>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5863877a5171c196453bfa0bd807e410)): ?>
<?php $attributes = $__attributesOriginal5863877a5171c196453bfa0bd807e410; ?>
<?php unset($__attributesOriginal5863877a5171c196453bfa0bd807e410); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5863877a5171c196453bfa0bd807e410)): ?>
<?php $component = $__componentOriginal5863877a5171c196453bfa0bd807e410; ?>
<?php unset($__componentOriginal5863877a5171c196453bfa0bd807e410); ?>
<?php endif; ?>
<?php /**PATH /Users/test/Documents/prisma1/resources/views/packages/index.blade.php ENDPATH**/ ?>