<?php
$finalPrice = $package->sale_price ?? $package->price;
$hasDiscount = $package->sale_price && $package->sale_price < $package->price;
$testsCount = $package->tests_count ?? $package->tests?->count() ?? 0;
?>

<div class="package-card" style="background: white; border-radius: 20px; box-shadow: 0 10px 40px rgba(0,0,0,0.04); transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1); position: relative; display: flex; flex-direction: column; overflow: hidden; border: 1px solid #f1f5f9;">
    
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showBadge && $package->badge_text): ?>
        <div style="position: absolute; top: 15px; right: 15px; background: linear-gradient(135deg, #FF5F6D 0%, #FFC371 100%); color: white; padding: 5px 15px; font-weight: 800; font-size: 0.75rem; z-index: 2; border-radius: 50px; box-shadow: 0 4px 10px rgba(255, 95, 109, 0.3);">
            <?php echo e($package->badge_text); ?>

        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    
    <div style="height: 200px; position: relative; overflow: hidden; background: #f8fafc;">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($package->image): ?>
            <img src="<?php echo e(asset('storage/' . $package->image)); ?>" alt="<?php echo e($package->name); ?>" style="width: 100%; height: 100%; object-fit: cover; transition: transform 0.6s;">
        <?php else: ?>
            <div style="width: 100%; height: 100%; background: linear-gradient(135deg, #f0f7f7 0%, #ffffff 100%); display: flex; align-items: center; justify-content: center;">
                <i class="fas fa-microscope" style="font-size: 3.5rem; color: #00A0B0; opacity: 0.15;"></i>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showTestsCount): ?>
        <div style="position: absolute; bottom: 15px; left: 15px; background: rgba(26, 54, 93, 0.9); backdrop-filter: blur(4px); padding: 5px 15px; border-radius: 50px; font-size: 0.75rem; font-weight: 800; color: white;">
            <?php echo e($testsCount); ?> تحليل
        </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

    
    <div style="padding: 25px; flex: 1; display: flex; flex-direction: column;">
        <h3 style="font-size: 1.3rem; font-weight: 800; color: #1A365D; margin-bottom: 12px; line-height: 1.4;"><?php echo e($package->name); ?></h3>
        
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showDescription): ?>
        <p style="font-size: 0.95rem; color: #64748b; line-height: 1.7; margin-bottom: 20px; flex: 1;">
            <?php echo e($package->short_description ?? Str::limit(strip_tags($package->description), 80)); ?>

        </p>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showFeatures && $package->features && count($package->features) > 0): ?>
            <div style="margin-bottom: 25px; display: grid; gap: 8px;">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = array_slice($package->features, 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div style="display: flex; align-items: center; gap: 10px; font-size: 0.85rem; color: #475569; font-weight: 600;">
                        <div style="width: 18px; height: 18px; background: #e0f2f1; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 0.6rem; color: #00A0B0;">
                            <i class="fas fa-check"></i>
                        </div>
                        <?php echo e(is_array($feature) ? ($feature['feature'] ?? '') : $feature); ?>

                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        
        <div style="display: flex; align-items: center; justify-content: space-between; gap: 15px; padding-top: 20px; border-top: 1px solid #f1f5f9;">
            <div style="display: flex; flex-direction: column;">
                <span style="font-size: 1.8rem; font-weight: 900; color: #1A365D; line-height: 1;">
                    <?php echo e(number_format($finalPrice, 0)); ?>

                    <span style="font-size: 0.9rem; font-weight: 700;"><?php echo e($riyalSymbol); ?></span>
                </span>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showOldPrice && $hasDiscount): ?>
                    <span style="font-size: 0.85rem; color: #94A3B8; text-decoration: line-through; font-weight: 600;">
                        <?php echo e(number_format($package->price, 0)); ?> <?php echo e($riyalSymbol); ?>

                    </span>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
            <button 
               wire:click="$dispatch('openPackageModal', { 
                   title: '<?php echo e(addslashes($package->name)); ?>',
                   description: '<?php echo e(addslashes($package->short_description ?? Str::limit(strip_tags($package->description), 120))); ?>',
                   price: <?php echo e($finalPrice); ?>,
                   price_non_saudi: <?php echo e(round($finalPrice * 1.15)); ?>,
                   original_price: <?php echo e($hasDiscount ? $package->price : 'null'); ?>,
                   discount_percent: <?php echo e($hasDiscount ? round((($package->price - $finalPrice) / $package->price) * 100) : 'null'); ?>,
                   image_url: '<?php echo e($package->image ? asset('storage/' . $package->image) : 'https://images.unsplash.com/photo-1579684385127-1ef15d508118?ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80'); ?>',
                   groups: <?php echo e(json_encode($package->test_groups ?? [])); ?>,
                   fasting: <?php echo e($package->requires_fasting ? 'true' : 'false'); ?>

               })"
               style="height: 48px; padding: 0 25px; font-size: 0.95rem; font-weight: 800; border-radius: 12px; transition: all 0.3s; background: #1A365D; color: white; display: flex; align-items: center; justify-content: center; box-shadow: 0 10px 20px rgba(26, 54, 93, 0.15); border: none; cursor: pointer;">
                تفاصيل
            </button>
        </div>
    </div>
</div>

<style>
    .package-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 30px 60px rgba(26, 54, 93, 0.1);
        border-color: rgba(0, 160, 176, 0.2);
    }
    .package-card:hover img { transform: scale(1.1); }
    .package-card:hover a { background: #00A0B0; box-shadow: 0 10px 20px rgba(0, 160, 176, 0.2); }
</style>
<?php /**PATH /Users/test/Documents/prisma1/resources/views/partials/package-card-sar.blade.php ENDPATH**/ ?>