<?php

$title = $data['title'] ?? "";
$subtitle = $data['subtitle'] ?? "";
$buttonText = $data['button_text'] ?? "";
$buttonUrl = $data['button_url'] ?? '#';
$buttonIcon = $data['button_icon'] ?? 'whatsapp';
$bgColorStart = $data['bg_color_start'] ?? '#1A365D';
$rounded = $data['rounded_corners'] ?? true;
$fullWidth = $data['full_width'] ?? true;
$marginTop = $data['margin_top'] ?? true;

$iconClass = match($buttonIcon) {
    'whatsapp' => 'fab fa-whatsapp',
    'phone' => 'fas fa-phone',
    'arrow' => 'fas fa-arrow-left',
    'calendar' => 'fas fa-calendar-check',
    default => 'fab fa-whatsapp',
};
?>

<section class="cta-section" style="padding: 100px 20px; background: linear-gradient(135deg, <?php echo e($bgColorStart); ?> 0%, <?php echo e($bgColorEnd); ?> 100%); position: relative; overflow: hidden; <?php echo e($rounded ? 'border-radius: 30px;' : ''); ?> <?php echo e($fullWidth ? '' : 'margin: ' . ($marginTop ? '60px 20px' : '0 20px') . ';'); ?> text-align: center;">
    
    <div style="position: absolute; inset: 0; opacity: 0.1; background-image: radial-gradient(white 1px, transparent 1px); background-size: 20px 20px;"></div>
    <div style="position: absolute; top: -50%; left: -50%; width: 200%; height: 200%; background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 60%); pointer-events: none;"></div>

    <div style="position: relative; z-index: 1; max-width: 800px; margin: 0 auto;">
        <h2 style="font-size: 3rem; font-weight: 800; color: white; margin-bottom: 20px; font-family: 'Cairo', sans-serif; text-shadow: 0 2px 10px rgba(0,0,0,0.1);">
            <?php echo e($title); ?>

        </h2>
        <p style="color: rgba(255,255,255,0.95); font-size: 1.3rem; margin-bottom: 40px; font-weight: 500; line-height: 1.6;">
            <?php echo e($subtitle); ?>

        </p>
        <div style="display: flex; justify-content: center; gap: 20px; flex-wrap: wrap;">
            <a href="<?php echo e($buttonUrl); ?>" style="padding: 18px 45px; background: white; color: #1A365D; border-radius: 50px; font-weight: 800; font-size: 1.15rem; text-decoration: none; display: inline-flex; align-items: center; gap: 12px; box-shadow: 0 15px 35px rgba(0,0,0,0.15); transition: all 0.3s;">
                <i class="<?php echo e($iconClass); ?>" style="font-size: 1.3rem; color: #00A0B0;"></i>
                <?php echo e($buttonText); ?>

            </a>
        </div>
    </div>
</section>

<style>
    .cta-section a:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 45px rgba(0,0,0,0.2);
        background: #f8fafc;
    }
</style>
<?php /**PATH /Users/test/Documents/prisma1/resources/views/components/blocks/prisma-cta.blade.php ENDPATH**/ ?>